package edu.ecompus.weixin.vo.send;

import java.util.LinkedList;
import java.util.List;

import org.jdom.Document;
import org.jdom.Element;
/**
 * 回复图文消息体
 * <li>items 子图文（第一项为大图）
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-1-9 上午11:06:13
 */
public class WxSendNewsMsg extends WxSendMsg {
	private List<WxSendNewsMsgItem> items = new LinkedList<WxSendNewsMsgItem>();

	public WxSendNewsMsg(WxSendMsg msg) {
		super(msg);
		setMsgType("news");
	}
	public void setItems(List<WxSendNewsMsgItem> items) {
		this.items = items;
	}
	
	/**
	 * 增加图文item
	 * @param title			图文消息标题
	 * @param description	图文消息描述
	 * @param picUrl		图片链接，支持JPG、PNG格式，较好的效果为大图360*200，小图200*200
	 * @param url			点击图文消息跳转链接
	 * @return
	 */
	public WxSendNewsMsg addItem(String title,String description,String picUrl,String url) {
		if(items.size() >= 10) {
			throw new IllegalArgumentException("只能接受最多10个item...");
		}
		items.add(new WxSendNewsMsgItem(title,description,picUrl,url));
		return this;
	}
	
	/**
	 * 增加item
	 * @param item
	 * @return
	 */
	public WxSendNewsMsg addItem(WxSendNewsMsgItem item) {
		if(items.size() >= 10) {
			throw new IllegalArgumentException("只能接受最多10个item...");
		}
		
		items.add(item);
		
		return this;
	}
	
	@Override
	public Document toDocument() {
		Document doc = super.toDocument();
		Element root = doc.getRootElement();
		createElement(root, "ArticleCount", String.valueOf(items.size()));
		Element articles = createElement(root, "Articles","");
		for(WxSendNewsMsgItem item : items) {
			Element i = createElement(articles, "item", "");
			createElement(i, "Title", item.getTitle());
			createElement(i, "Description", item.getDescription());
			createElement(i, "PicUrl", item.getPicUrl());
			createElement(i, "Url", item.getUrl());
		}
		return doc;
	}
}