package edu.ecompus.weixin.vo.send;

import org.jdom.Document;

import edu.ecompus.weixin.vo.WxMsg;

/**
 * 空串消息包
 * 假如服务器无法保证在五秒内处理并回复，可以直接回复空串，微信服务器不会对此作任何处理，并且不会发起重试。 这种情况下，可以使用客服消息接口进行异步回复。
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-7-22 下午4:05:42
 */
public class WxSendBlankMsg extends WxSendMsg {

	public WxSendBlankMsg(WxMsg msg) {
		super(msg);
		setMsgType("text");
	}
	
	
	@Override
	public Document toDocument() {
		Document doc = super.toDocument();
		createElement(doc.getRootElement(), "Content", "");
		return doc;
	}

}
