package edu.ecompus.weixin.vo.customer;

/**
 * 文本消息
 * 
 * 参数	是否必须	说明
	<li>access_token	 是	 调用接口凭证
	<li>touser	 是	 普通用户openid
	<li>msgtype	 是	 消息类型，text
	<li>content	 是	 文本消息内容
 * @source
 * 		{
		    "touser":"OPENID",
		    "msgtype":"text",
		    "text":
		    {
		         "content":"Hello World"
		    }
		}
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-8-30 下午3:05:46
 */
public class WxCustomerTextMsg extends WxCustomerMsg implements WxCustomer {
	/**
	 * 文本消息内容
	 */
	private String content;
	
	public WxCustomerTextMsg(String touser, String content) {
		super(touser, "text");
		this.content = content;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getJson(){
		String base = super.getJson();
		
		StringBuilder data = new StringBuilder("\"content\":\"").append(content).append("\"");
		base = base.replaceAll("##data##", data.toString());
		return base;
		
	}
	
}
