package edu.ecompus.weixin.vo.customer;
/**
 * 【客服消息】音乐消息
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-8-30 下午4:04:41
 */
public class WxCustomerMusicMsg extends WxCustomerMsg implements WxCustomer {

	/**
	 * 音乐链接
	 */
	private String musicurl;
	/**
	 * 高品质音乐链接，wifi环境优先使用该链接播放音乐
	 */
	private String hqmusicurl;
	
	/**
	 * 缩略图的媒体ID
	 */
	private String thumbMediaId;
	/**
	 * 音乐标题
	 */
	private String title;
	/**
	 * 音乐描述
	 */
	private String description; 
	
	public WxCustomerMusicMsg(String touser, String title, String description, String musicurl, String hqmusicurl, String thumbMediaId) {
		super(touser, "music");
		this.musicurl = musicurl;
		this.hqmusicurl = hqmusicurl;
		this.thumbMediaId = thumbMediaId;
		this.title = title;
		this.description = description;
	}
	
	public String getJson(){
		String base = super.getJson();
		
		StringBuilder data = new StringBuilder("\"title\":\"").append(title).append("\"");
		data.append(",\"description\":\"").append(description).append("\"");
		data.append(",\"musicurl\":\"").append(musicurl).append("\"");
		data.append(",\"hqmusicurl\":\"").append(hqmusicurl).append("\"");
		data.append(",\"thumb_media_id\":\"").append(thumbMediaId).append("\"");
		
		base = base.replaceAll("##data##", data.toString());
		return base;
		
	}

	public String getMusicurl() {
		return musicurl;
	}

	public void setMusicurl(String musicurl) {
		this.musicurl = musicurl;
	}

	public String getHqmusicurl() {
		return hqmusicurl;
	}

	public void setHqmusicurl(String hqmusicurl) {
		this.hqmusicurl = hqmusicurl;
	}

	public String getThumbMediaId() {
		return thumbMediaId;
	}

	public void setThumbMediaId(String thumbMediaId) {
		this.thumbMediaId = thumbMediaId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	

}
