package edu.ecompus.weixin.vo;

import net.sf.json.JSONObject;

/**
 * 返回JSON数据包
 * <li><a href = "http://mp.weixin.qq.com/wiki/index.php?title=%E5%85%A8%E5%B1%80%E8%BF%94%E5%9B%9E%E7%A0%81%E8%AF%B4%E6%98%8E">全局返回码说明</a>
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-9-1 下午3:57:08
 */
public class WxReturnJson {
	/**
	 * 错误时微信会返回错误码等信息
	 */
	private String errcode;
	/**
	 * 错误时微信会返回错误码等信息
	 */
	private String errmsg;
	/**
	 * 消息ID
	 */
	private String msgId;
	
	/**
	 * 媒体文件类型，分别有图片（image）、语音（voice）、视频（video）、缩略图（thumb，主要用于视频与音乐格式的缩略图）、次数为news，即图文消息
	 */
	private String type;
	/**
	 * 媒体文件上传后，获取时的唯一标识
	 */
	private String mediaId;
	/**
	 * 媒体文件上传时间戳
	 */
	private String createdAt;
	
	
	public WxReturnJson(String json){
		this(JSONObject.fromObject(json));
	}
	
	public WxReturnJson(JSONObject obj){
		if(obj!=null && obj.get("errcode")!=null){
			this.errcode = obj.getString("errcode");
			this.errmsg = obj.getString("errmsg");
		}else if(obj!=null && obj.get("type")!=null){
			this.mediaId = obj.getString("media_id");
			this.type = obj.getString("type");
			this.createdAt = obj.getString("created_at");
		}
		
		if(obj!=null && obj.get("msg_id")!=null){
			this.msgId = obj.getString("msg_id");
		}
		
		
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getMediaId() {
		return mediaId;
	}

	public void setMediaId(String mediaId) {
		this.mediaId = mediaId;
	}

	public String getCreatedAt() {
		return createdAt;
	}

	public void setCreatedAt(String createdAt) {
		this.createdAt = createdAt;
	}

	public String getErrcode() {
		return errcode;
	}

	public void setErrcode(String errcode) {
		this.errcode = errcode;
	}

	public String getErrmsg() {
		return errmsg;
	}

	public void setErrmsg(String errmsg) {
		this.errmsg = errmsg;
	}

	public String getMsgId() {
		return msgId;
	}

	public void setMsgId(String msgId) {
		this.msgId = msgId;
	}
	
	
	
}
