package edu.ecompus.weixin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;


import net.sf.json.JSONException;
import net.sf.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 微信自定义菜单工具类
 * 
 * 
 * CopyRright (c) 2013: <紫悦新橙> Project: <数字化校园 > Module ID:
 * <(模块)类编号，可以引用系统设计中的类编号> Comments: <对此类的描述，可以引用系统设计中的描述> JDK version used:
 * <JDK1.6>
 * 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-10-10 上午10:49:21
 */
public class WeiXinMenuUtil {
	/**日志**/
	private static Logger log = LoggerFactory.getLogger(WeiXinMenuUtil.class);

	/**
	 * 根据token创建菜单
	 * @param menu
	 * @param token
	 * @return
	 */
	public static String createMenu(String menu, String token) {
		String action = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token="+ token;
		
		try {
			URL url = new URL(action);
			HttpURLConnection http = (HttpURLConnection) url.openConnection();

			http.setRequestMethod("POST");
			http.setRequestProperty("Content-Type", 	"application/x-www-form-urlencoded");
			http.setDoOutput(true);
			http.setDoInput(true);
			System.setProperty("sun.net.client.defaultConnectTimeout", "30000");// 连接超时30秒
			System.setProperty("sun.net.client.defaultReadTimeout", "30000"); // 读取超时30秒

			http.connect();
			OutputStream os = http.getOutputStream();
			os.write(menu.getBytes("UTF-8"));// 传入参数
			os.flush();
			os.close();

			InputStream is = http.getInputStream();
			int size = is.available();
			byte[] jsonBytes = new byte[size];
			is.read(jsonBytes);
			String message = new String(jsonBytes, "UTF-8");
			return "返回信息" + message;
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return "createMenu 失败";
	}
	
	/**
	 * 根据APPID与APPSECRET创建菜单	创建Menu
	 * 
	 * @Title: createMenu
	 * @Description: 创建Menu
	 * @param @return
	 * @param @throws IOException 设定文件
	 * @return int 返回类型
	 * @throws
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static JSONObject createMenu(String menu, String APPID, String APPSECRET) throws JSONException {
		if(log.isInfoEnabled()){
			log.info("根据APPID与APPSECRET创建菜单");
		}
		// 此处改为自己想要的结构体，替换即可
		String access_token = null;
		Map map = new HashMap();
		try {
			access_token = WeiXin.getAccess_token(APPID,APPSECRET);
		} catch (Exception e1) {
			e1.printStackTrace();
		}
		//{"errcode":0,"errmsg":"ok"}
		//JSONObject.fromObject(message)
		if(access_token==null){
			map.put("code", "0");
			map.put("msg", "access_token error");
			
			return JSONObject.fromObject(map);
		}

		String action = String.format(WeiXinApiGlobal.MENU_CREATE_URL, access_token); 
		try {
			URL url = new URL(action);
			HttpURLConnection http = (HttpURLConnection) url.openConnection();

			http.setRequestMethod("POST");
			http.setRequestProperty("Content-Type", 	"application/x-www-form-urlencoded");
			http.setDoOutput(true);
			http.setDoInput(true);
			System.setProperty("sun.net.client.defaultConnectTimeout", "30000");// 连接超时30秒
			System.setProperty("sun.net.client.defaultReadTimeout", "30000"); // 读取超时30秒

			http.connect();
			OutputStream os = http.getOutputStream();
			os.write(menu.getBytes("UTF-8"));// 传入参数
			os.flush();
			os.close();

			InputStream is = http.getInputStream();
			int size = is.available();
			byte[] jsonBytes = new byte[size];
			is.read(jsonBytes);
			
			JSONObject json=JSONObject.fromObject(new String(jsonBytes, "UTF-8"));
			
			map.put("code", "1");
			map.put("errcode", json.get("errcode"));
			map.put("errmsg", json.get("errmsg"));
			//return JSONObject.fromObject(map);
		} catch (MalformedURLException e) {
			e.printStackTrace();
			map.put("code", "0");
			map.put("msg", e.getMessage());
		} catch (IOException e) {
			map.put("code", "0");
			map.put("msg", e.getMessage());
			e.printStackTrace();
		}
		
		return JSONObject.fromObject(map);
	}

	/**
	 * 删除当前Menu
	 * 
	 * @Title: deleteMenu
	 * @Description: 删除当前Menu
	 * @param @return 设定文件
	 * @return String 返回类型
	 * @throws
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static JSONObject deleteMenu(String APPID, String APPSECRET) {
		if(log.isInfoEnabled()){
			log.info("根据APPID与APPSECRET删除自定义菜单");
		}
		// 此处改为自己想要的结构体，替换即可
		String access_token = null;
		Map map = new HashMap();
		try {
			access_token = WeiXin.getAccess_token(APPID,APPSECRET);
		} catch (Exception e1) {
			e1.printStackTrace();
		}
		//{"errcode":0,"errmsg":"ok"}
		//JSONObject.fromObject(message)
		if(access_token==null){
			map.put("code", "0");
			map.put("msg", "access_token error");
			
			return JSONObject.fromObject(map);
		}
		
		
		
		String action = String.format(WeiXinApiGlobal.MENU_DELETE_URL, access_token); 
		try {
			URL url = new URL(action);
			HttpURLConnection http = (HttpURLConnection) url.openConnection();

			http.setRequestMethod("GET");
			http.setRequestProperty("Content-Type",	"application/x-www-form-urlencoded");
			http.setDoOutput(true);
			http.setDoInput(true);
			System.setProperty("sun.net.client.defaultConnectTimeout", "30000");// 连接超时30秒
			System.setProperty("sun.net.client.defaultReadTimeout", "30000"); // 读取超时30秒

			http.connect();
			OutputStream os = http.getOutputStream();
			os.flush();
			os.close();

			InputStream is = http.getInputStream();
			int size = is.available();
			byte[] jsonBytes = new byte[size];
			is.read(jsonBytes);
			
			
			JSONObject json=JSONObject.fromObject(new String(jsonBytes, "UTF-8"));
			map.put("code", "1");
			map.put("errcode", json.get("errcode"));
			map.put("errmsg", json.get("errmsg"));
		} catch (MalformedURLException e) {
			e.printStackTrace();
			map.put("code", "0");
			map.put("msg", e.getMessage());
		} catch (IOException e) {
			e.printStackTrace();
			map.put("code", "0");
			map.put("msg", e.getMessage());
		}
		
		return JSONObject.fromObject(map);
	}
	
	
	
	

	public static void main(String[] args) {
		String menu = "{\"button\":[{\"type\":\"click\",\"name\":\"MENU01\",\"key\":\"1\"},{\"type\":\"click\",\"name\":\"天气查询\",\"key\":\"西安\"},{\"name\":\"日常工作\",\"sub_button\":[{\"type\":\"click\",\"name\":\"待办工单\",\"key\":\"01_WAITING\"},{\"type\":\"click\",\"name\":\"已办工单\",\"key\":\"02_FINISH\"},{\"type\":\"click\",\"name\":\"我的工单\",\"key\":\"03_MYJOB\"},{\"type\":\"click\",\"name\":\"公告消息箱\",\"key\":\"04_MESSAGEBOX\"},{\"type\":\"click\",\"name\":\"签到\",\"key\":\"05_SIGN\"}]}]}";
		
		System.out.println(createMenu(menu,"wx4edd204b4e62eb51","5032ee6b3762c559edb6ceafc9c00979"));

	}
}
