package edu.ecompus.weixin;



/**
 * 微信API定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-10-12 上午10:45:26
 */
public final class WeiXinApiGlobal {
	/**
	 * 访问KEY
	 */
	public static String AccessToken = "";
	
	//=========================常量===========================================
	/**
	 * 基础支持: 获取access_token接口 /token
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E8%8E%B7%E5%8F%96access_token">查看文档</a>
	 */
	public final static String TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
	
	/**
	 * 基础支持: 多媒体文件上传接口 /media/upload 
	 * @param access_token	访问Token
	 * @since 公众号可调用本接口来上传图片、语音、视频等文件到微信服务器，上传后服务器会返回对应的media_id，公众号此后可根据该media_id来获取多媒体。请注意，media_id是可复用的，调用该接口需http协议。<b>body</b>
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E4%B8%8A%E4%BC%A0%E4%B8%8B%E8%BD%BD%E5%A4%9A%E5%AA%92%E4%BD%93%E6%96%87%E4%BB%B6">查看文档</a>
	 */
	public final static String MEDIA_UPLOAD_URL = "http://file.api.weixin.qq.com/cgi-bin/media/upload?access_token=%s&type=%s";
	
	/**
	 * 基础支持: 下载多媒体文件接口 /media/get
	 * @param access_token	访问Token
	 * @param media_id		媒体文件ID(上传时获得，三天内有效）
	 * @since	公众号可调用本接口来获取多媒体文件。请注意，调用该接口需http协议。
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E4%B8%8A%E4%BC%A0%E4%B8%8B%E8%BD%BD%E5%A4%9A%E5%AA%92%E4%BD%93%E6%96%87%E4%BB%B6">查看文档</a>
	 */
	public final static String MEDIA_GET_URL = "http://file.api.weixin.qq.com/cgi-bin/media/get?access_token=%s&media_id=%s";
	
	/**
	 * 向用户发送消息: 发送客服消息接口 /message/custom/send
	 * @param access_token TOKEN
	 * @since <b>body</b>
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E5%8F%91%E9%80%81%E5%AE%A2%E6%9C%8D%E6%B6%88%E6%81%AF">查看文档</a>
	 */
	public final static String MESSAGE_SEND_URL = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=%s";
	
	/**
	 * 用户管理: 获取关注者列表接口 /user/get
	 * @param access_token	访问Token
	 * @param next_openid		第一个拉取的OPENID，不填默认从头开始拉取
	 * @since	公众号可通过本接口来获取帐号的关注者列表，关注者列表由一串OpenID（加密后的微信号，每个用户对每个公众号的OpenID是唯一的）组成。一次拉取调用最多拉取10000个关注者的OpenID，可以通过多次拉取的方式来满足需求。
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E8%8E%B7%E5%8F%96%E5%85%B3%E6%B3%A8%E8%80%85%E5%88%97%E8%A1%A8">查看文档</a>
	 */
	public final static String USER_GET_URL = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=%s&next_openid=%s";
	
	/**
	 * 用户管理: 获取用户基本信息接口 /user/info
	 * @param access_token	访问Token
	 * @param openid		普通用户的标识，对当前公众号唯一
	 * @since 在关注者与公众号产生消息交互后，公众号可获得关注者的OpenID（加密后的微信号，每个用户对每个公众号的OpenID是唯一的。对于不同公众号，同一用户的openid不同）。公众号可通过本接口来根据OpenID获取用户基本信息，包括昵称、头像、性别、所在城市、语言和关注时间。
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E8%8E%B7%E5%8F%96%E7%94%A8%E6%88%B7%E5%9F%BA%E6%9C%AC%E4%BF%A1%E6%81%AF">查看文档</a>
	 */
	public final static String USER_INFO_URL = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s";
	
	/**
	 * 用户管理: 查询分组接口 /groups/get
	 * @param access_token	访问Token
	 * @since 开发者可以使用接口，对公众平台的分组进行查询、创建、修改操作，也可以使用接口在需要时移动用户到某个分组。<b>body</b>
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E5%88%86%E7%BB%84%E7%AE%A1%E7%90%86%E6%8E%A5%E5%8F%A3">查看文档</a>
	 */
	public final static String GROUPS_GET_URL = "https://api.weixin.qq.com/cgi-bin/groups/get?access_token=%s";
	
	/**
	 * 用户管理: 创建分组接口 /groups/create
	 * @param access_token	访问Token
	 * @since 一个公众账号，最多支持创建500个分组。 接口调用请求说明<b>body</b>
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E5%88%86%E7%BB%84%E7%AE%A1%E7%90%86%E6%8E%A5%E5%8F%A3">查看文档</a>
	 */
	public final static String GROUPS_CREATE_URL = "https://api.weixin.qq.com/cgi-bin/groups/create?access_token=%s";
	
	/**
	 * 用户管理: 修改分组名接口 /groups/update
	 * @param access_token	访问Token
	 * @since 接口调用请求说明<b>body</b>
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E5%88%86%E7%BB%84%E7%AE%A1%E7%90%86%E6%8E%A5%E5%8F%A3">查看文档</a>
	 */
	public final static String GROUPS_UPDATE_URL = "https://api.weixin.qq.com/cgi-bin/groups/update?access_token=%s";
	
	/**
	 * 用户管理: 移动用户分组接口 /groups/members/update
	 * @param access_token	访问Token
	 * @since 接口调用请求说明<b>body</b>
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E5%88%86%E7%BB%84%E7%AE%A1%E7%90%86%E6%8E%A5%E5%8F%A3">查看文档</a>
	 */
	public final static String GROUPS_MEMBERS_UPDATE_URL = "https://api.weixin.qq.com/cgi-bin/groups/members/update?access_token=%s";
	
	/**
	 * 自定义菜单: 自定义菜单创建接口 /menu/create
	 * @param access_token	访问Token
	 * @since 目前自定义菜单最多包括3个一级菜单，每个一级菜单最多包含5个二级菜单。一级菜单最多4个汉字，二级菜单最多7个汉字，多出来的部分将会以“...”代替。 <b>body</b>
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E8%87%AA%E5%AE%9A%E4%B9%89%E8%8F%9C%E5%8D%95%E5%88%9B%E5%BB%BA%E6%8E%A5%E5%8F%A3">查看文档</a>
	 */
	public final static String MENU_CREATE_URL = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=%s";
	
	/**
	 * 自定义菜单: 自定义菜单查询接口 /menu/get
	 * @param access_token	访问Token
	 * @since 使用接口创建自定义菜单后，开发者还可使用接口查询自定义菜单的结构。
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E8%87%AA%E5%AE%9A%E4%B9%89%E8%8F%9C%E5%8D%95%E6%9F%A5%E8%AF%A2%E6%8E%A5%E5%8F%A3">查看文档</a>
	 */
	public final static String MENU_GET_URL = "https://api.weixin.qq.com/cgi-bin/menu/get?access_token=%s";
	
	/**
	 * 自定义菜单: 自定义菜单删除接口 /menu/delete
	 * @param access_token	访问Token
	 * @since 使用接口创建自定义菜单后，开发者还可使用接口删除当前使用的自定义菜单。
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E8%87%AA%E5%AE%9A%E4%B9%89%E8%8F%9C%E5%8D%95%E5%88%A0%E9%99%A4%E6%8E%A5%E5%8F%A3">查看文档</a>
	 */
	public final static String MENU_DELETE_URL = "https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=%s";
	
	/**
	 * 推广支持: 创建二维码ticket接口 /qrcode/create
	 * @param access_token	访问Token
	 * @since 每次创建二维码ticket需要提供一个开发者自行设定的参数（scene_id），分别介绍临时二维码和永久二维码的创建二维码ticket过程。 <b>body</b>
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E7%94%9F%E6%88%90%E5%B8%A6%E5%8F%82%E6%95%B0%E7%9A%84%E4%BA%8C%E7%BB%B4%E7%A0%81">查看文档</a>
	 */
	public final static String QRCODE_CREATE_URL = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=%s";
	
	/**
	 * 推广支持: 通过ticket换取二维码
	 * @param ticket	获取的二维码ticket，凭借此ticket可以在有效时间内换取二维码。
	 * @since 获取二维码ticket后，开发者可用ticket换取二维码图片。请注意，本接口无须登录态即可调用。
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E7%94%9F%E6%88%90%E5%B8%A6%E5%8F%82%E6%95%B0%E7%9A%84%E4%BA%8C%E7%BB%B4%E7%A0%81">查看文档</a>
	 */
	public final static String QRCODE_SHOW_URL = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=%s";
	
	
	/**
	 * 上传图文消息素材
	 * @see <a href="http://mp.weixin.qq.com/wiki/index.php?title=%E9%AB%98%E7%BA%A7%E7%BE%A4%E5%8F%91%E6%8E%A5%E5%8F%A3">查看文档</a>
	 */
	public final static String UPLOADNEWS_URL = "https://api.weixin.qq.com/cgi-bin/media/uploadnews?access_token=%s";
}
