package edu.ecompus.weixin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.sf.json.JSONObject;

import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import edu.ecompus.weixin.parser.WxMsgKit;
import edu.ecompus.weixin.vo.recv.WxRecvMsg;
import edu.ecompus.weixin.vo.send.WxSendMsg;

/**
 * 微信工具类
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-30 上午9:54:21
 */
public final class WeiXin {
	/**日志**/
	static Logger log = LoggerFactory.getLogger(WeiXin.class);
	
	/**
	 * 发送消息(POST)
	 * @return
	 * @throws Exception
	 */
	public static JSONObject send(String urlPath, String data) {
		try {
			URL url = new URL(urlPath);
			HttpURLConnection http = (HttpURLConnection) url.openConnection();

			http.setRequestMethod("POST");
			http.setRequestProperty("Content-Type", 	"application/x-www-form-urlencoded");
			http.setDoOutput(true);
			http.setDoInput(true);
			System.setProperty("sun.net.client.defaultConnectTimeout", "30000");// 连接超时30秒
			System.setProperty("sun.net.client.defaultReadTimeout", "30000"); // 读取超时30秒

			http.connect();
			OutputStream os = http.getOutputStream();
			os.write(data.getBytes("UTF-8"));// 传入参数
			os.flush();
			os.close();

			InputStream is = http.getInputStream();
			int size = is.available();
			byte[] jsonBytes = new byte[size];
			is.read(jsonBytes);
			String message = new String(jsonBytes, "UTF-8");
			
			return JSONObject.fromObject(message);
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		return null;
	}
	
	/**
	 * 发送消息(Get)
	 * @return
	 * @throws Exception
	 */
	public static JSONObject get(String urlPath, String data) {
		try {
			URL url = new URL(urlPath);
			HttpURLConnection http = (HttpURLConnection) url.openConnection();

			http.setRequestMethod("GET");
			http.setRequestProperty("Content-Type", 	"application/x-www-form-urlencoded");
			http.setDoOutput(true);
			http.setDoInput(true);
			System.setProperty("sun.net.client.defaultConnectTimeout", "30000");// 连接超时30秒
			System.setProperty("sun.net.client.defaultReadTimeout", "30000"); // 读取超时30秒

			http.connect();
			OutputStream os = http.getOutputStream();
			os.write(data.getBytes("UTF-8"));// 传入参数
			os.flush();
			os.close();

			InputStream is = http.getInputStream();
			int size = is.available();
			byte[] jsonBytes = new byte[size];
			is.read(jsonBytes);
			String message = new String(jsonBytes, "UTF-8");
			
			return JSONObject.fromObject(message);
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		return null;
	}
	
	/**
	 * 获得ACCESS_TOKEN
	 * 
	 * @Title: getAccess_token
	 * @Description: 获得ACCESS_TOKEN
	 * @param	APPID
	 * @param   APPSECRET 
	 * @return String 返回Access_Token
	 * @throws
	 */
	public static String getAccess_token(String APPID, String APPSECRET) throws Exception {
		if(log.isInfoEnabled()){
			log.info("getAccess_token 获取access_token APPID="+APPID+" APPSECRET="+APPSECRET);
		}
		String url = String.format(WeiXinApiGlobal.TOKEN_URL, APPID,APPSECRET) ;
				
		URL urlGet = new URL(url);
		HttpURLConnection http = (HttpURLConnection) urlGet.openConnection();

		http.setRequestMethod("GET"); // 必须是get方式请求
		http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
		http.setDoOutput(true);
		http.setDoInput(true);
		System.setProperty("sun.net.client.defaultConnectTimeout", "30000");// 连接超时30秒
		System.setProperty("sun.net.client.defaultReadTimeout", "30000"); // 读取超时30秒

		http.connect();

		InputStream is = http.getInputStream();
		int size = is.available();
		byte[] jsonBytes = new byte[size];
		is.read(jsonBytes);
		String message = new String(jsonBytes, "UTF-8");

		JSONObject demoJson = JSONObject.fromObject(message);
		
		return demoJson.getString("access_token");
	}
	
	/**
	 * 判断加密串是否正确 
	 * @param token				自定义令牌
	 * @param signature			加密串
	 * @param timestamp			时间搓
	 * @param nonce				随机串
	 * @return
	 */
	public static boolean access(String token,String signature,String timestamp,String nonce) {
		if(log.isInfoEnabled()){
			log.info("access checkSignature");
			log.info("			signature="+signature);
			log.info("			timestamp="+timestamp);
			log.info("			nonce="+nonce);
		}
		
		List<String> ss = new ArrayList<String>();
		ss.add(timestamp);
		ss.add(nonce);
		ss.add(token);
		
		Collections.sort(ss);
		
		StringBuilder builder = new StringBuilder();
		for(String s : ss) {
			builder.append(s);
		}
		return signature.equalsIgnoreCase(HashKitUtil.sha1(builder.toString()));
	}
	
	/**
	 * 接收XML消息体,并转换为实体
	 * @param in
	 * @return
	 * @throws JDOMException
	 * @throws IOException
	 */
	public static WxRecvMsg recv(InputStream in) throws JDOMException, IOException {
		if(log.isInfoEnabled()){
			log.info("recv in is not null?"+(in!=null));
		}
		return WxMsgKit.parse(in);
	}
	
	/**
	 * 发送消息体
	 * @param msg
	 * @param out
	 * @throws JDOMException
	 * @throws IOException
	 */
	public static void send(WxSendMsg msg,OutputStream out) throws JDOMException,IOException {
		if(log.isInfoEnabled()){
			log.info("send msg="+msg);
		}
		
		Document doc = WxMsgKit.parse(msg);
		if(null != doc) {
			new XMLOutputter().output(doc, out);
		} else {
			if(log.isInfoEnabled()){
				log.info("发送消息时,解析出dom为空 msg :"+msg);
			}
		}
	}
	
	/**
	 * 生成发送消息体
	 * @param msg
	 * @return
	 */
	public static WxSendMsg builderSendByRecv(WxRecvMsg msg) {
		if(log.isInfoEnabled()){
			log.info("builderSendByRecv msg="+msg);
		}
		
		WxRecvMsg m = new WxRecvMsg(msg);
		String from = m.getFromUser();
		m.setFromUser(m.getToUser());
		m.setToUser(from);
		m.setCreateDt(String.valueOf((System.currentTimeMillis() / 1000)));
		return new WxSendMsg(m);
	}
	
	
}
