/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.weixin.parser;

import edu.ecompus.weixin.parser.WxRecvEventMsgParser;
import edu.ecompus.weixin.parser.WxRecvGeoMsgParser;
import edu.ecompus.weixin.parser.WxRecvLinkMsgParser;
import edu.ecompus.weixin.parser.WxRecvMsgParser;
import edu.ecompus.weixin.parser.WxRecvPicMsgParser;
import edu.ecompus.weixin.parser.WxRecvTextMsgParser;
import edu.ecompus.weixin.parser.WxRecvVoiceRecognitionMsgParser;
import edu.ecompus.weixin.vo.recv.WxRecvMsg;
import edu.ecompus.weixin.vo.send.WxSendMsg;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class WxMsgKit {
    private static final Map<String, WxRecvMsgParser> recvParserMap = new HashMap<String, WxRecvMsgParser>();

    public static WxRecvMsg parse(InputStream in) throws JDOMException, IOException {
        Document dom = new SAXBuilder().build(in);
        Element msgType = dom.getRootElement().getChild("MsgType");
        if (null != msgType) {
            String txt = msgType.getText().toLowerCase();
            WxRecvMsgParser parser = recvParserMap.get(txt);
            if (null != parser) {
                return parser.parser(dom);
            }
            System.out.println(txt);
        }
        return null;
    }

    public static Document parse(WxSendMsg msg) throws JDOMException {
        return msg.toDocument();
    }

    static {
        recvParserMap.put("text", new WxRecvTextMsgParser());
        recvParserMap.put("link", new WxRecvLinkMsgParser());
        recvParserMap.put("location", new WxRecvGeoMsgParser());
        recvParserMap.put("image", new WxRecvPicMsgParser());
        recvParserMap.put("event", new WxRecvEventMsgParser());
        recvParserMap.put("voice", new WxRecvVoiceRecognitionMsgParser());
    }
}

