/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.weixin.vo.send;

import edu.ecompus.weixin.vo.send.WxSendMsg;
import edu.ecompus.weixin.vo.send.WxSendNewsMsgItem;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class WxSendNewsMsg
extends WxSendMsg {
    private List<WxSendNewsMsgItem> items = new LinkedList<WxSendNewsMsgItem>();

    public WxSendNewsMsg(WxSendMsg msg) {
        super(msg);
        this.setMsgType("news");
    }

    public void setItems(List<WxSendNewsMsgItem> items) {
        this.items = items;
    }

    public WxSendNewsMsg addItem(String title, String description, String picUrl, String url) {
        if (this.items.size() >= 10) {
            throw new IllegalArgumentException("\u53ea\u80fd\u63a5\u53d7\u6700\u591a10\u4e2aitem...");
        }
        this.items.add(new WxSendNewsMsgItem(title, description, picUrl, url));
        return this;
    }

    @Override
    public Document toDocument() {
        Document doc = super.toDocument();
        Element root = doc.getRootElement();
        this.createElement(root, "ArticleCount", String.valueOf(this.items.size()));
        Element articles = this.createElement(root, "Articles", "");
        for (WxSendNewsMsgItem item : this.items) {
            Element i = this.createElement(articles, "item", "");
            this.createElement(i, "Title", item.getTitle());
            this.createElement(i, "Description", item.getDescription());
            this.createElement(i, "PicUrl", item.getPicUrl());
            this.createElement(i, "Url", item.getUrl());
        }
        return doc;
    }
}

