/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.weixin;

import edu.ecompus.weixin.HashKitUtil;
import edu.ecompus.weixin.parser.WxMsgKit;
import edu.ecompus.weixin.vo.recv.WxRecvMsg;
import edu.ecompus.weixin.vo.send.WxSendMsg;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import net.sf.json.JSONObject;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WeiXin {
    static Logger log = LoggerFactory.getLogger(WeiXin.class);

    public static String getAccess_token(String APPID, String APPSECRET) {
        if (log.isInfoEnabled()) {
            log.info("getAccess_token \u83b7\u53d6access_token");
        }
        String url = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", APPID, APPSECRET);
        String accessToken = null;
        try {
            URL urlGet = new URL(url);
            HttpURLConnection http = (HttpURLConnection)urlGet.openConnection();
            http.setRequestMethod("GET");
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            http.setDoOutput(true);
            http.setDoInput(true);
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
            System.setProperty("sun.net.client.defaultReadTimeout", "30000");
            http.connect();
            InputStream is = http.getInputStream();
            int size = is.available();
            byte[] jsonBytes = new byte[size];
            is.read(jsonBytes);
            String message = new String(jsonBytes, "UTF-8");
            JSONObject demoJson = JSONObject.fromObject((Object)message);
            accessToken = demoJson.getString("access_token");
            if (log.isInfoEnabled()) {
                log.info(String.format("message=%s         ,accessToken=%s", message, accessToken));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return accessToken;
    }

    public static boolean access(String token, String signature, String timestamp, String nonce) {
        if (log.isInfoEnabled()) {
            log.info("access checkSignature");
            log.info("\t\t\tsignature=" + signature);
            log.info("\t\t\ttimestamp=" + timestamp);
            log.info("\t\t\tnonce=" + nonce);
        }
        ArrayList<String> ss = new ArrayList<String>();
        ss.add(timestamp);
        ss.add(nonce);
        ss.add(token);
        Collections.sort(ss);
        StringBuilder builder = new StringBuilder();
        for (String s : ss) {
            builder.append(s);
        }
        return signature.equalsIgnoreCase(HashKitUtil.sha1(builder.toString()));
    }

    public static WxRecvMsg recv(InputStream in) throws JDOMException, IOException {
        if (log.isInfoEnabled()) {
            log.info("recv in is not null?" + (in != null));
        }
        return WxMsgKit.parse(in);
    }

    public static void send(WxSendMsg msg, OutputStream out) throws JDOMException, IOException {
        Document doc;
        if (log.isInfoEnabled()) {
            log.info("send msg=" + msg);
        }
        if (null != (doc = WxMsgKit.parse(msg))) {
            new XMLOutputter().output(doc, out);
        } else if (log.isInfoEnabled()) {
            log.info("\u53d1\u9001\u6d88\u606f\u65f6,\u89e3\u6790\u51fadom\u4e3a\u7a7a msg :" + msg);
        }
    }

    public static WxSendMsg builderSendByRecv(WxRecvMsg msg) {
        if (log.isInfoEnabled()) {
            log.info("builderSendByRecv msg=" + msg);
        }
        WxRecvMsg m = new WxRecvMsg(msg);
        String from = m.getFromUser();
        m.setFromUser(m.getToUser());
        m.setToUser(from);
        m.setCreateDt(String.valueOf(System.currentTimeMillis() / 1000L));
        return new WxSendMsg(m);
    }
}

