/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.util;

import com.oreilly.servlet.multipart.FileRenamePolicy;
import java.io.File;

public class RandomFileRenamePolicy
implements FileRenamePolicy {
    private String targetPath;
    private String oldFileName;

    public RandomFileRenamePolicy(String targetPath) {
        this.targetPath = targetPath;
        if (this.targetPath != null && !"".equals(this.targetPath)) {
            File f1 = new File(targetPath);
            if (!f1.exists()) {
                f1.mkdirs();
            }
            Object var2_2 = null;
        }
    }

    public File rename(File file) {
        this.oldFileName = file.getName();
        file = this.targetPath != null && !"".equals(this.targetPath) ? new File(this.targetPath, this.getNewFileName(file.getName())) : new File(file.getParent(), this.getNewFileName(file.getName()));
        return file;
    }

    public String getNewFileName(String fileName) {
        String fType = RandomFileRenamePolicy.getFiletype(fileName);
        String ffrontname = RandomFileRenamePolicy.getFilefrontname(fileName);
        ffrontname = ffrontname.replace(',', '_');
        ffrontname = ffrontname.replace('#', '_');
        ffrontname = ffrontname.replace('&', '_');
        ffrontname = ffrontname.replace('%', '\uff05');
        String newFileName = "S" + System.currentTimeMillis() + "." + fType;
        return newFileName;
    }

    public static String getFiletype(String fileName) {
        String type = "";
        if (fileName == null || fileName.equals("")) {
            return type;
        }
        int position = fileName.lastIndexOf(".");
        if (position != -1) {
            type = fileName.substring(position + 1, fileName.length());
        }
        return type;
    }

    public static String getFilefrontname(String fileName) {
        String name = "";
        if (fileName == null || fileName.equals("")) {
            return name;
        }
        int position = fileName.lastIndexOf(".");
        if (position != -1) {
            name = fileName.substring(0, position);
        }
        String newname = "";
        newname = name.trim().replaceAll(" ", "");
        newname = newname.replaceAll("%", "_");
        newname = newname.replaceAll("\\+", "_");
        return newname;
    }

    public String getOldFileName() {
        return this.oldFileName;
    }

    public void setOldFileName(String oldFileName) {
        this.oldFileName = oldFileName;
    }
}

