/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.quartz;

import edu.ecompus.core.common.exception.ML2BaseException;
import edu.ecompus.core.quartz.QuartzJobFactory;
import edu.ecompus.core.quartz.QuartzJobSyncFactory;
import edu.ecompus.core.quartz.QuartzScheduleJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzManager {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzManager.class);

    public static TriggerKey getTriggerKey(String jobName, String jobGroup) {
        return TriggerKey.triggerKey((String)jobName, (String)jobGroup);
    }

    public static CronTrigger getCronTrigger(Scheduler scheduler, String jobName, String jobGroup) throws ML2BaseException {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
            return (CronTrigger)scheduler.getTrigger(triggerKey);
        }
        catch (SchedulerException e) {
            LOG.error("\u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1CronTrigger\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new ML2BaseException("\u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1CronTrigger\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static void createScheduleJob(Scheduler scheduler, QuartzScheduleJob job) throws SchedulerException, ML2BaseException {
        LOG.debug(scheduler + ".......................................................................................add");
        TriggerKey triggerKey = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
        CronTrigger trigger = (CronTrigger)scheduler.getTrigger(triggerKey);
        if (null == trigger) {
            Class clazz = job.getIsSync() != false ? QuartzJobSyncFactory.class : QuartzJobFactory.class;
            JobDetail jobDetail = JobBuilder.newJob(clazz).withIdentity(job.getJobName(), job.getJobGroup()).build();
            jobDetail.getJobDataMap().put("QuartzScheduleJobParam", (Object)job);
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCronExpression());
            trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(job.getJobName(), job.getJobGroup()).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        } else {
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCronExpression());
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
        }
    }

    public static void runOnce(Scheduler scheduler, String jobName, String jobGroup) throws ML2BaseException {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        try {
            scheduler.triggerJob(jobKey);
        }
        catch (SchedulerException e) {
            LOG.error("\u8fd0\u884c\u4e00\u6b21\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new ML2BaseException("\u8fd0\u884c\u4e00\u6b21\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public static void pauseJob(Scheduler scheduler, String jobName, String jobGroup) throws ML2BaseException {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        try {
            scheduler.pauseJob(jobKey);
        }
        catch (SchedulerException e) {
            LOG.error("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new ML2BaseException("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public static void resumeJob(Scheduler scheduler, String jobName, String jobGroup) throws ML2BaseException {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        try {
            scheduler.resumeJob(jobKey);
        }
        catch (SchedulerException e) {
            LOG.error("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new ML2BaseException("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public static JobKey getJobKey(String jobName, String jobGroup) {
        return JobKey.jobKey((String)jobName, (String)jobGroup);
    }

    public static void updateScheduleJob(Scheduler scheduler, QuartzScheduleJob scheduleJob) throws ML2BaseException {
        QuartzManager.updateScheduleJob(scheduler, scheduleJob.getJobName(), scheduleJob.getJobGroup(), scheduleJob.getCronExpression(), scheduleJob.getIsSync(), scheduleJob);
    }

    public static void updateScheduleJob(Scheduler scheduler, String jobName, String jobGroup, String cronExpression, boolean isSync, Object param) throws ML2BaseException {
        try {
            TriggerKey triggerKey = QuartzManager.getTriggerKey(jobName, jobGroup);
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
            CronTrigger trigger = (CronTrigger)scheduler.getTrigger(triggerKey);
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            LOG.error("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new ML2BaseException("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public static void deleteScheduleJob(Scheduler scheduler, String jobName, String jobGroup) throws ML2BaseException {
        try {
            scheduler.deleteJob(QuartzManager.getJobKey(jobName, jobGroup));
        }
        catch (SchedulerException e) {
            LOG.error("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new ML2BaseException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }
}

