/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.interceptor;

import edu.ecompus.core.util.HttpUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class PerformanceHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(PerformanceHandlerInterceptor.class);
    private static final String START_TIME = "perf_start";

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Long startTime = (Long)request.getAttribute(START_TIME);
        if (startTime != null) {
            long last = System.currentTimeMillis() - startTime;
            logger.info("Request for URI: " + HttpUtil.getURL(request));
            logger.info("Performace: " + last + "ms.");
        }
    }

    public void postHandle(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse, Object obj, ModelAndView modelandview) throws Exception {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute(START_TIME, (Object)System.currentTimeMillis());
        return true;
    }
}

