/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.util;

import com.oreilly.servlet.MultipartRequest;
import com.oreilly.servlet.multipart.FileRenamePolicy;
import edu.ecompus.core.util.RandomFileRenamePolicy;
import java.io.File;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class FlashUploadRequest {
    HttpServletRequest request;
    int MaxSize = 314572800;
    String fileName;
    String uploadDir;
    RandomFileRenamePolicy cospolicy;

    public FlashUploadRequest(HttpServletRequest request) {
        this.request = request;
        this.uploadDir = "";
    }

    public File upload() throws Exception {
        this.cospolicy = new RandomFileRenamePolicy(this.uploadDir);
        MultipartRequest multi = new MultipartRequest(this.request, this.uploadDir, this.MaxSize, "UTF-8", (FileRenamePolicy)this.cospolicy);
        Enumeration files = multi.getFileNames();
        while (files.hasMoreElements()) {
            String name = (String)files.nextElement();
            File f = multi.getFile(name);
            if (!f.isFile() || !f.exists()) continue;
            this.fileName = this.cospolicy.getOldFileName();
            return f;
        }
        return null;
    }

    public int getMaxSize() {
        return this.MaxSize;
    }

    public void setMaxSize(int maxSize) {
        this.MaxSize = maxSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getUploadDir() {
        return this.uploadDir;
    }

    public void setUploadDir(String uploadDir) {
        File dir;
        this.uploadDir = uploadDir;
        if (this.uploadDir != null && !"".equals(this.uploadDir) && (dir = new File(this.uploadDir)).isDirectory() && !dir.exists()) {
            dir.mkdirs();
        }
    }

    public String getSourceFileName() {
        if (this.cospolicy != null) {
            return this.cospolicy.getOldFileName();
        }
        return null;
    }
}

