/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

public class FileUtil {
    public static void removeFile(File file) {
        for (int maxTry = 3; maxTry > 0; --maxTry) {
            if (file.isFile()) {
                if (!file.delete()) continue;
                return;
            }
            return;
        }
    }

    public static boolean delFile(String filePathAndName) {
        boolean ret = false;
        try {
            new File(filePathAndName.toString()).delete();
            ret = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean delFiles(String dir) {
        boolean ret = false;
        try {
            File filePath = new File(dir);
            String[] files = filePath.list();
            int i = 0;
            for (i = 0; i < files.length; ++i) {
                new File(dir + File.separator + files[i]).delete();
            }
            ret = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean isExist(String filename) {
        boolean ret = false;
        try {
            File file = new File(filename.toString());
            if (file.exists()) {
                ret = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean uploadFile(File file, String dir, String filename) {
        boolean ret = false;
        try {
            if (file != null) {
                int len;
                File filePath = new File(dir);
                if (!filePath.exists()) {
                    filePath.mkdir();
                }
                String target = dir + filename;
                FileOutputStream outputStream = new FileOutputStream(target);
                FileInputStream fileIn = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                while ((len = fileIn.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, len);
                }
                fileIn.close();
                outputStream.close();
                ret = true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return ret;
    }

    public static void SaveFileFromInputStream(InputStream stream, String path, String filename) throws IOException {
        FileOutputStream fs = new FileOutputStream(path + File.separator + filename);
        byte[] buffer = new byte[0x100000];
        int bytesum = 0;
        int byteread = 0;
        while ((byteread = stream.read(buffer)) != -1) {
            bytesum += byteread;
            fs.write(buffer, 0, byteread);
            fs.flush();
        }
        fs.close();
        stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFile(File file, OutputStream output) throws IOException {
        FileInputStream input = null;
        AbstractInterruptibleChannel fc = null;
        try {
            input = new FileInputStream(file);
            fc = input.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            while (true) {
                buffer.clear();
                int n = ((FileChannel)fc).read(buffer);
                if (n == -1) {
                    break;
                }
                output.write(buffer.array(), 0, buffer.position());
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException e) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] data) throws IOException {
        int MAX_BUFFER_SIZE = 4096;
        FileOutputStream output = null;
        AbstractInterruptibleChannel fc = null;
        try {
            int len;
            output = new FileOutputStream(file);
            fc = output.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(MAX_BUFFER_SIZE);
            for (int offset = 0; offset < data.length; offset += len) {
                buffer.clear();
                len = data.length - offset;
                if (len > MAX_BUFFER_SIZE) {
                    len = MAX_BUFFER_SIZE;
                }
                buffer.put(data, offset, len);
                buffer.flip();
                ((FileChannel)fc).write(buffer);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException e) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            return fileName.substring(index + 1, fileName.length());
        }
        return fileName;
    }

    public static String getFileNameNotExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    public static String getFileNameRandom() {
        String format = "yyyyMMddHHmmss";
        Random r = new Random();
        int rannum = (int)(r.nextDouble() * 9000.0) + 1000;
        String name = new SimpleDateFormat(format).format(new Date());
        name = name + rannum;
        return name;
    }

    public static void createDirs(String dir) {
        File fdir = new File(dir);
        FileUtil.createDirs(fdir);
    }

    public static void createDirs(File dir) {
        dir.mkdirs();
    }

    public static void saveAs(String sourcefile, String targerfile) throws Exception {
        int n;
        InputStreamReader in = new InputStreamReader(new FileInputStream(sourcefile));
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(targerfile), "utf-8");
        char[] cbuf = new char[1024];
        while ((n = in.read(cbuf)) != -1) {
            out.write(cbuf, 0, n);
        }
        in.close();
        out.close();
    }

    public static List<File> getFiles(String dir, String fileTypes, List<File> files) {
        File realFile = new File(dir);
        if (realFile.isDirectory()) {
            File[] subfiles;
            for (File file : subfiles = realFile.listFiles()) {
                if (file.isDirectory()) {
                    FileUtil.getFiles(file.getAbsolutePath(), fileTypes, files);
                    continue;
                }
                String fileT = FileUtil.getExtension(file.getName());
                if (fileTypes == null || fileTypes.indexOf(fileT.toLowerCase()) < 0) continue;
                files.add(file);
            }
        }
        return files;
    }

    public static void main(String[] args) {
        String dir = "E:\\\u5a5a\u793c";
        List<File> filelist = FileUtil.getFiles(dir, ".png,.jpg", new ArrayList<File>());
        for (File file : filelist) {
            System.out.println(file.getPath());
        }
    }
}

