/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.filter;

import edu.ecompus.core.filter.AbstractCacheFilter;
import edu.ecompus.core.filter.CachedResponseWrapper;
import edu.ecompus.core.filter.HttpServletRequestFactory;
import edu.ecompus.core.util.FileUtil;
import edu.ecompus.core.util.GZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.Resource;

public class FileCacheFilter
extends AbstractCacheFilter {
    private String root;
    private final String SUFFIX = ".html";

    public final void setFileDir(Resource dir) {
        try {
            File f = dir.getFile();
            f.mkdirs();
            if (!f.isDirectory()) {
                throw new IllegalArgumentException("Invalid directoy: " + f.getPath());
            }
            if (!f.canWrite()) {
                throw new IllegalArgumentException("Cannot write to directory: " + f.getPath());
            }
            this.root = f.getPath();
            if (!this.root.endsWith("/") && !this.root.endsWith("//")) {
                this.root = this.root + "/";
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (!new File(this.root).isDirectory()) {
            throw new IllegalArgumentException("No directory: " + this.root);
        }
    }

    public void remove(String url, Map parameters) {
        String key = this.getKey(HttpServletRequestFactory.create(url, parameters));
        if (key != null) {
            FileUtil.removeFile(this.key2File(key));
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String key = this.getKey(httpRequest);
        if (key == null) {
            chain.doFilter(request, response);
        } else {
            File file = this.key2File(key);
            if (file.isFile()) {
                logger.info("Load cached file from: " + file.getPath());
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.setContentType(this.getContentType());
                httpResponse.setHeader("Content-Encoding", "gzip");
                httpResponse.setContentLength((int)file.length());
                FileUtil.readFile(file, (OutputStream)httpResponse.getOutputStream());
            } else {
                logger.info("Cannot find cached file. Create new cached file...");
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                CachedResponseWrapper wrapper = new CachedResponseWrapper(httpResponse);
                chain.doFilter(request, (ServletResponse)wrapper);
                if (wrapper.getStatus() == 200) {
                    byte[] data = GZipUtil.gzip(wrapper.getResponseData());
                    FileUtil.writeFile(file, data);
                    logger.info("Page is cached to file.");
                    httpResponse.setContentType(this.getContentType());
                    httpResponse.setHeader("Content-Encoding", "gzip");
                    httpResponse.setContentLength(data.length);
                    httpResponse.getOutputStream().write(data);
                } else {
                    logger.warn("Cannot cache page because response code is not 200.");
                }
            }
        }
    }

    private File key2File(String key) {
        int hash = key.hashCode();
        int dir1 = (hash & 0xFF00) >> 8;
        int dir2 = hash & 0xFF;
        String dir = this.root + dir1 + "/" + dir2;
        File fdir = new File(dir);
        if (!fdir.isDirectory() && !fdir.mkdirs()) {
            return null;
        }
        return new File(dir + "/" + this.encode(key) + ".html");
    }

    private String encode(String key) {
        try {
            return URLEncoder.encode(key, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

