/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.dao.impl;

import edu.ecompus.core.common.exception.ML2DaoException;
import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.jdbc.Work;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ML2TemplateGenericDao<Model, PK extends Serializable>
implements ML2GenericDao<Model, PK> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected JdbcTemplate jdbcTemplate = null;
    @Autowired
    protected SessionFactory sessionFactory;
    protected final Class clazz;

    public ML2TemplateGenericDao(Class clazz) {
        this.clazz = clazz;
    }

    public Session getSession() {
        if (this.sessionFactory == null) {
            throw new ML2DaoException("\u672a\u914d\u7f6eSessionFactory,\u8bf7\u67e5\u770bXML\u6587\u4ef6! ");
        }
        return this.sessionFactory.getCurrentSession();
    }

    public Session getNewSession() {
        if (this.sessionFactory == null) {
            throw new ML2DaoException("\u672a\u914d\u7f6eSessionFactory,\u8bf7\u67e5\u770bXML\u6587\u4ef6! ");
        }
        return this.sessionFactory.openSession();
    }

    @Override
    public Model get(PK id) {
        Session session = this.getSession();
        return (Model)session.get(this.clazz, id);
    }

    @Override
    public void create(Model t) {
        try {
            Session session = this.getNewSession();
            session.save(t);
            session.flush();
            session.clear();
            session.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void delete(Model t) {
        Session session = this.getNewSession();
        session.delete(t);
        session.flush();
        session.clear();
        session.close();
    }

    @Override
    public void deleteByPK(PK id) {
        Session session = this.getNewSession();
        Object obj = session.get(this.clazz, id);
        session.delete(obj);
        this.flush();
        this.clear();
    }

    @Override
    public void deleteByList(PK[] ids) {
        for (PK id : ids) {
            Object obj = this.getSession().get(this.clazz, id);
            if (obj == null) continue;
            this.getSession().delete(obj);
        }
    }

    @Override
    public void update(Model t) {
        Session session = this.getNewSession();
        session.update(t);
        session.flush();
        session.clear();
        session.close();
    }

    @Override
    public List getAllList() {
        String hql = "from " + this.clazz.getName();
        Session session = this.getSession();
        return session.createQuery(hql).list();
    }

    @Override
    public Long getTotalCount() {
        Session session = this.getNewSession();
        String hql = "select count(id) from " + this.clazz.getName();
        Long count = (Long)session.createQuery(hql).uniqueResult();
        session.close();
        return count != null ? count : 0L;
    }

    @Override
    public void flush() {
        this.getSession().flush();
    }

    @Override
    public void clear() {
        this.getSession().clear();
    }

    @Override
    public void queryHql(String hqlString, Object ... values) {
        Query query = this.getSession().createQuery(hqlString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        query.executeUpdate();
    }

    @Override
    public void querySql(String sqlString, Object ... values) {
        SQLQuery query = this.getSession().createSQLQuery(sqlString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        query.executeUpdate();
    }

    @Override
    public Model getByHQL(String hqlString, Object ... values) {
        Query query = this.getSession().createQuery(hqlString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return (Model)query.uniqueResult();
    }

    @Override
    public Model getBySQL(String sqlString, Object ... values) {
        SQLQuery query = this.getSession().createSQLQuery(sqlString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return (Model)query.uniqueResult();
    }

    @Override
    public List<Model> getListByHQL(String hqlString, Object ... values) {
        Query query = this.getSession().createQuery(hqlString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return query.list();
    }

    @Override
    public List<Model> getListBySQL(String sqlString, Object ... values) {
        SQLQuery query = this.getSession().createSQLQuery(sqlString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return query.list();
    }

    @Override
    public List findListBySql(final String sql, final RowMapper map, final Object ... values) {
        final ArrayList list = new ArrayList();
        Work jdbcWork = new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection connection) throws SQLException {
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    ps = connection.prepareStatement(sql);
                    for (int i = 0; i < values.length; ++i) {
                        ML2TemplateGenericDao.this.setParameter(ps, i, values[i]);
                    }
                    rs = ps.executeQuery();
                    int index = 0;
                    while (rs.next()) {
                        Object obj = map.mapRow(rs, index++);
                        list.add(obj);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        };
        this.getSession().doWork(jdbcWork);
        return list;
    }

    @Override
    public Long countByHql(String hql, Object ... values) {
        Query query = this.getSession().createQuery(hql);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return (Long)query.uniqueResult();
    }

    @Override
    public Page<Model> findPageByFetchedHql(String hql, String countHql, int pageNo, int pageSize, Object ... values) {
        Page retValue = new Page();
        Query query = this.getSession().createQuery(hql);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        int currentPage = pageNo > 1 ? pageNo : 1;
        retValue.setPageNo(currentPage);
        retValue.setPageSize(pageSize);
        if (countHql == null) {
            ScrollableResults results = query.scroll();
            results.last();
            retValue.setTotalCount(results.getRowNumber() + 1);
        } else {
            Long count = this.countByHql(countHql, values);
            retValue.setTotalCount(count.intValue());
        }
        retValue.resetPageNo();
        ArrayList itemList = query.setFirstResult((currentPage - 1) * pageSize).setMaxResults(pageSize).list();
        if (itemList == null) {
            itemList = new ArrayList();
        }
        retValue.setResults(itemList);
        return retValue;
    }

    private void setParameter(PreparedStatement ps, int pos, Object data) throws SQLException {
        if (data == null) {
            ps.setNull(pos + 1, 12);
            return;
        }
        Class<?> dataCls = data.getClass();
        if (String.class.equals(dataCls)) {
            ps.setString(pos + 1, (String)data);
        } else if (Boolean.TYPE.equals(dataCls)) {
            ps.setBoolean(pos + 1, (Boolean)data);
        } else if (Integer.TYPE.equals(dataCls)) {
            ps.setInt(pos + 1, (Integer)data);
        } else if (Double.TYPE.equals(dataCls)) {
            ps.setDouble(pos + 1, (Double)data);
        } else if (Date.class.equals(dataCls)) {
            Date val = (Date)data;
            ps.setTimestamp(pos + 1, new Timestamp(val.getTime()));
        } else if (BigDecimal.class.equals(dataCls)) {
            ps.setBigDecimal(pos + 1, (BigDecimal)data);
        } else {
            ps.setObject(pos + 1, data);
        }
    }
}

