package edu.ecompus.core.util;


import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;




/**
 * 根据 user agent string 判断用户的平台、浏览器
 * 参考资料
 * **************************************************************************************************************************************************
 * 
 * 台式机
 * 
 * Linux Ubuntu
 * Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9.2.2pre) Gecko/20100225 Ubuntu/9.10 (karmic) Namoroka/3.6.2pre
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * Linux Mandriva 2008.1
 * Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9.0.1) Gecko/2008072403 Mandriva/3.0.1-1mdv2008.1 (2008.1) firefox/3.0.1
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * Linux suSE 10.1
 * Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.0.3) Gecko/20060425 SUSE/1.5.0.3-7 firefox/1.5.0.31
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * windows XP SP3
 * Mozilla/5.0 (windows; U; windows nt 5.1; en-US; rv:1.9.1) Gecko/20090624 firefox/3.5 (.NET CLR 3.5.30729)
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * windows Vista
 * Mozilla/5.0 (windows; U; windows nt 6.1; nl; rv:1.9.2.13) Gecko/20101203 firefox/3.6.13
 * Mozilla/5.0 (windows; U; windows nt 6.0; en-US; rv:1.9.2.6) Gecko/20100625 firefox/3.6.6 (.NET CLR 3.5.30729)
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * windows 2000
 * Mozilla/5.0 (windows; U; windows nt 5.0; en-GB; rv:1.8.1b2) Gecko/20060821 firefox/2.0b2
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * windows 7
 * Mozilla/5.0 (windows nt 6.1; WOW64; rv:14.0) Gecko/20100101 firefox/14.0.1
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * windows Server 2008
 * Mozilla/5.0 (windows; U; windows NT 6.1; en-US; rv:1.9.1.5) Gecko/20091102 firefox/3.5.5 (.NET CLR 3.5.30729)
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * iMac OSX 10.7.4
 * Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:13.0) Gecko/20100101 firefox/13.0.1
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * Mac OS X
 * Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.6; en-US; rv:1.9.2.9) Gecko/20100824 firefox/3.6.9
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * 
 * 手持设备
 * 
 * iPad
 * Mozilla/5.0 (iPad; U; CPU OS 3_2 like Mac OS X; en-us) AppleWebKit/531.21.10 (KHTML, like Gecko) Version/4.0.4 Mobile/7B334b Safari/531.21.10
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * iPad 2
 * Mozilla/5.0 (iPad; CPU OS 5_1 like Mac OS X; en-us) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.1 Mobile/9B176 Safari/7534.48.3
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * iPhone 4
 * Mozilla/5.0 (iPhone; U; CPU iPhone OS 4_0 like Mac OS X; en-us) AppleWebKit/532.9 (KHTML, like Gecko) Version/4.0.5 Mobile/8A293 Safari/6531.22.7
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * iPhone 5
 * Mozilla/5.0 (iPhone; CPU iPhone OS 5_0 like Mac OS X) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.1 Mobile/9A334 Safari/7534.48.3
 * --------------------------------------------------------------------------------------------------------------------------------------------------
 * Android
 * Mozilla/5.0 (Linux; U; Android 2.2; en-us; Nexus One Build/FRF91) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1
 * **************************************************************************************************************************************************
 * @author Defonds
 */
public class UserAgentUtil {
	static Logger logger = LoggerFactory.getLogger(UserAgentUtil.class);
	//移动浏览器
	static String[] mobileAgents = {"iphone", "android", "phone"
		, "mobile", "wap", "netfront", "java", "opera mobi", "opera mini", "ucweb"
		, "windows ce", "symbian", "series", "webos", "sony", "blackberry"
		, "dopod", "nokia", "samsung", "palmsource", "xda", "pieplus", "meizu", "midp"
		, "cldc", "motorola", "foma", "docomo"
		, "up.browser", "up.link", "blazer", "helio", "hosin", "huawei", "novarra", "coolpad"
		, "webos", "techfaith", "palmsource", "alcatel", "amoi", "ktouch", "nexian"
		, "ericsson", "philips", "sagem", "wellcom", "bunjalloo", "maui", "smartphone", "iemobile", "spice", "bird", "zte-", "longcos", "pantech", "gionee", "portalmmm", "jig browser", "hiptop", "benq", "haier", "^lct", "320x320", "240x320", "176x220", "w3c ", "acs-", "alav", "alca", "amoi", "audi", "avan", "benq", "bird", "blac", "blaz", "brew", "cell", "cldc", "cmd-", "dang", "doco", "eric", "hipt", "inno", "ipaq", "java", "jigs", "kddi", "keji", "leno", "lg-c", "lg-d", "lg-g", "lge-", "maui", "maxo", "midp", "mits", "mmef", "mobi", "mot-", "moto", "mwbp", "nec-", "newt", "noki", "oper", "palm", "pana", "pant", "phil", "play", "port", "prox", "qwap", "sage", "sams", "sany", "sch-", "sec-", "send", "seri", "sgh-", "shar", "sie-", "siem", "smal", "smar", "sony", "sph-", "symb", "t-mo", "teli"
		, "tim-", "tsm-", "upg1", "upsi", "vk-v", "voda", "wap-", "wapa", "wapi", "wapp", "wapr", "webc", "winw", "winw", "xda", "xda-", "Googlebot-Mobile"};
	//Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7) AppleWebKit/534.48.3 (KHTML, like Gecko) Version/5.1 Safari/534.48.3
	public static UserAgentSO getUserAgent(HttpServletRequest request) {
		if(request==null){
			return null;
		}
		String ua = request.getHeader("user-agent");
		logger.info(ua);
		ua = ua.toLowerCase();
		UserAgentSO agent = getUserAgent(ua);
		agent.setUa(ua);
		agent.setQueryString(request.getQueryString());
		agent.setTrident(ua.indexOf("Trident")>-1);
		agent.setPresto(ua.indexOf("Presto")>-1);
		agent.setWebKit(ua.indexOf("AppleWebKit")>-1);
		agent.setGecko(ua.indexOf("Gecko") > -1 && ua.indexOf("KHTML") == -1);
		//是否是微信浏览器 micromessenger
		agent.setIsweixin(ua.indexOf("micromessenger") > -1);
		for(String ma : mobileAgents){
			if(ua.indexOf(ma)>=0){
				agent.setIsmobile(true);
				break;
			}
		}
		//TODO
		return agent;
	}

	/**
	 * 用途：根据客户端 User Agent Strings 判断其浏览器、操作平台
	 * if 判断的先后次序：
	 * 根据设备的用户使用量降序排列，这样对于大多数用户来说可以少判断几次即可拿到结果：
	 * 	>>操作系统:windows > 苹果 > 安卓 > Linux > ...
	 * 	>>Browser:chrome > FF > IE > ...
	 * @param userAgentStr
	 * @return
	 */
	public static UserAgentSO getUserAgent(String userAgent) {
		if(userAgent!=null && !"".equals(userAgent)){
			userAgent = userAgent.toLowerCase();
		}
		if (userAgent.contains("windows")) {//主流应用靠前
			/**
			 * ******************
			 * 台式机 windows 系列
			 * ******************
			 * windows NT 6.2	-	windows 8
			 * windows NT 6.1	-	windows 7
			 * windows NT 6.0	-	windows Vista
			 * windows NT 5.2	-	windows Server 2003; windows XP x64 Edition
			 * windows NT 5.1	-	windows XP
			 * windows NT 5.01	-	windows 2000, Service Pack 1 (SP1)
			 * windows NT 5.0	-	windows 2000
			 * windows NT 4.0	-	Microsoft windows NT 4.0
			 * windows 98; Win 9x 4.90	-	windows Millennium Edition (windows Me)
			 * windows 98	-	windows 98
			 * windows 95	-	windows 95
			 * windows CE	-	windows CE
			 * 判断依据:http://msdn.microsoft.com/en-us/library/ms537503(v=vs.85).aspx
			 */
			if (userAgent.contains("windows nt 6.2")) {//windows 8
				return judgeBrowser(userAgent, "windows", "8" , null);//判断浏览器
			} else if (userAgent.contains("windows nt 6.1")) {//windows 7
				return judgeBrowser(userAgent, "windows", "7" , null);
			} else if (userAgent.contains("windows nt 6.0")) {//windows Vista
				return judgeBrowser(userAgent, "windows", "Vista" , null);
			} else if (userAgent.contains("windows nt 5.2")) {//windows XP x64 Edition
				return judgeBrowser(userAgent, "windows", "XP" , "x64 Edition");
			} else if (userAgent.contains("windows nt 5.1")) {//windows XP
				return judgeBrowser(userAgent, "windows", "XP" , null);
			} else if (userAgent.contains("windows nt 5.01")) {//windows 2000, Service Pack 1 (SP1)
				return judgeBrowser(userAgent, "windows", "2000" , "SP1");
			} else if (userAgent.contains("windows nt 5.0")) {//windows 2000
				return judgeBrowser(userAgent, "windows", "2000" , null);
			} else if (userAgent.contains("windows nt 4.0")) {//Microsoft windows nt 4.0
				return judgeBrowser(userAgent, "windows", "NT 4.0" , null);
			} else if (userAgent.contains("windows 98; Win 9x 4.90")) {//windows Millennium Edition (windows Me)
				return judgeBrowser(userAgent, "windows", "ME" , null);
			} else if (userAgent.contains("windows 98")) {//windows 98
				return judgeBrowser(userAgent, "windows", "98" , null);
			} else if (userAgent.contains("windows 95")) {//windows 95
				return judgeBrowser(userAgent, "windows", "95" , null);
			} else if (userAgent.contains("windows CE")) {//windows CE
				return judgeBrowser(userAgent, "windows", "CE" , null);
			} 
		} else if (userAgent.contains("mac os x")) {
			/**
			 * ********
			 * 苹果系列
			 * ********
			 * iPod	-		Mozilla/5.0 (iPod; U; CPU iPhone OS 4_3_1 like Mac OS X; zh-cn) AppleWebKit/533.17.9 (KHTML, like Gecko) Version/5.0.2 Mobile/8G4 Safari/6533.18.5
			 * iPad	-		Mozilla/5.0 (iPad; U; CPU OS 3_2 like Mac OS X; en-us) AppleWebKit/531.21.10 (KHTML, like Gecko) Version/4.0.4 Mobile/7B334b Safari/531.21.10
			 * iPad2	-		Mozilla/5.0 (iPad; CPU OS 5_1 like Mac OS X; en-us) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.1 Mobile/9B176 Safari/7534.48.3
			 * iPhone 4	-	Mozilla/5.0 (iPhone; U; CPU iPhone OS 4_0 like Mac OS X; en-us) AppleWebKit/532.9 (KHTML, like Gecko) Version/4.0.5 Mobile/8A293 Safari/6531.22.7
			 * iPhone 5	-	Mozilla/5.0 (iPhone; CPU iPhone OS 5_0 like Mac OS X) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.1 Mobile/9A334 Safari/7534.48.3
			 * 判断依据:http://www.useragentstring.com/pages/Safari/
			 * 参考:http://stackoverflow.com/questions/7825873/what-is-the-ios-5-0-user-agent-string
			 * 参考:http://stackoverflow.com/questions/3105555/what-is-the-iphone-4-user-agent
			 */
			if (userAgent.contains("ipod")) {
				return judgeBrowser(userAgent, "ipod", null , null);//判断浏览器
			}
		}
		
		return new UserAgentSO();
	}
	
	/**
	 * 用途：根据客户端 User Agent Strings 判断其浏览器
	 * if 判断的先后次序：
	 * 根据浏览器的用户使用量降序排列，这样对于大多数用户来说可以少判断几次即可拿到结果：
	 * 	>>Browser:chrome > FF > IE > ...
	 * @param userAgent:user agent
	 * @param platformType:平台
	 * @param platformSeries:系列
	 * @param platformVersion:版本
	 * @return
	 */
	private static UserAgentSO judgeBrowser(String userAgent, String platformType, String platformSeries, String platformVersion) {
		if(userAgent!=null && !"".equals(userAgent)){
			userAgent = userAgent.toLowerCase();
		}
		
		if (userAgent.contains("chrome")) {
			/**
			 * ***********
			 * chrome 系列
			 * ***********
			 * chrome 24.0.1295.0	-	Mozilla/5.0 (windows nt 6.2; WOW64) AppleWebKit/537.15 (KHTML, like Gecko) chrome/24.0.1295.0 Safari/537.15
			 * chrome 24.0.1292.0	-	Mozilla/5.0 (windows nt 6.2; WOW64) AppleWebKit/537.14 (KHTML, like Gecko) chrome/24.0.1292.0 Safari/537.14
			 * chrome 24.0.1290.1	-	Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.13 (KHTML, like Gecko) chrome/24.0.1290.1 Safari/537.13
			 * 判断依据:http://www.useragentstring.com/pages/chrome/
			 */
			String temp = userAgent.substring(userAgent.indexOf("chrome/") + 7);//拿到User Agent String "chrome/" 之后的字符串,结果形如"24.0.1295.0 Safari/537.15"或"24.0.1295.0"
			String chromeVersion = null;
			if (temp.indexOf(" ") < 0) {//temp形如"24.0.1295.0"
				chromeVersion = temp;
			} else {//temp形如"24.0.1295.0 Safari/537.15"
				chromeVersion = temp.substring(0, temp.indexOf(" "));
			}
			return new UserAgentSO("chrome", chromeVersion, platformType, platformSeries, platformVersion);
		} else if (userAgent.contains("firefox")) {
			/**
			 * *******
			 * FF 系列
			 * *******
			 * firefox 16.0.1	-	Mozilla/5.0 (windows nt 6.2; Win64; x64; rv:16.0.1) Gecko/20121011 firefox/16.0.1
			 * firefox 15.0a2	-	Mozilla/5.0 (windows nt 6.1; rv:15.0) Gecko/20120716 firefox/15.0a2
			 * firefox 15.0.2	-	Mozilla/5.0 (windows nt 6.2; WOW64; rv:15.0) Gecko/20120910144328 firefox/15.0.2
			 * 判断依据:http://www.useragentstring.com/pages/firefox/
			 */
			String temp = userAgent.substring(userAgent.indexOf("firefox/") + 8);//拿到User Agent String "firefox/" 之后的字符串,结果形如"16.0.1 Gecko/20121011"或"16.0.1"
			String ffVersion = null;
			if (temp.indexOf(" ") < 0) {//temp形如"16.0.1"
				ffVersion = temp;
			} else {//temp形如"16.0.1 Gecko/20121011"
				ffVersion = temp.substring(0, temp.indexOf(" "));
			}
			return new UserAgentSO("firefox", ffVersion, platformType, platformSeries, platformVersion);
		} else if (userAgent.contains("msie")) {
			/**
			 * *******
			 * IE 系列
			 * *******
			 * msie 10.0	-	Internet Explorer 10
			 * msie 9.0	-	Internet Explorer 9
			 * msie 8.0	-	Internet Explorer 8 or IE8 Compatibility View/Browser Mode
			 * msie 7.0	-	windows Internet Explorer 7 or IE7 Compatibility View/Browser Mode
			 * msie 6.0	-	Microsoft Internet Explorer 6
			 * 判断依据:http://msdn.microsoft.com/en-us/library/ms537503(v=vs.85).aspx
			 */
			if (userAgent.contains("msie 10.0")) {//Internet Explorer 10
				return new UserAgentSO("Internet Explorer", "10", platformType, platformSeries, platformVersion);
			} else if (userAgent.contains("msie 9.0")) {//Internet Explorer 9
				return new UserAgentSO("Internet Explorer", "9", platformType, platformSeries, platformVersion);
			} else if (userAgent.contains("msie 8.0")) {//Internet Explorer 8
				return new UserAgentSO("Internet Explorer", "8", platformType, platformSeries, platformVersion);
			} else if (userAgent.contains("msie 7.0")) {//Internet Explorer 7
				return new UserAgentSO("Internet Explorer", "7", platformType, platformSeries, platformVersion);
			} else if (userAgent.contains("msie 6.0")) {//Internet Explorer 6
				return new UserAgentSO("Internet Explorer", "6", platformType, platformSeries, platformVersion);
			}
		} else {//暂时支持以上三个主流.其它浏览器,待续...
			return new UserAgentSO(null, null, platformType, platformSeries, platformVersion);
		}
		return null;
	}
	
	/**
	 * <script>
	var pc_style = ""
	var browser = {
	versions: function () {
	var u = navigator.userAgent, app = navigator.appVersion;
	return {
	trident: u.indexOf('Trident') > -1,
	presto: u.indexOf('Presto') > -1,
	webKit: u.indexOf('AppleWebKit') > -1,
	gecko: u.indexOf('Gecko') > -1 && u.indexOf('KHTML') == -1,
	mobile: !!u.match(/AppleWebKit.*Mobile.* /) || !!u.match(/AppleWebKit/) && u.indexOf('QIHU') && u.indexOf('QIHU') > -1 && u.indexOf('chrome') < 0,
	ios: !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/),
	android: u.indexOf('Android') > -1 || u.indexOf('Linux') > -1,
	iPhone: u.indexOf('iPhone') > -1 || u.indexOf('Mac') > -1,
	iPad: u.indexOf('iPad') > -1,
	webApp: u.indexOf('Safari') == -1,
	ua: u
	};
	}(),
	language: (navigator.browserLanguage || navigator.language).toLowerCase()
	}

	if (browser.versions.mobile && !browser.versions.iPad) {
	this.location = "http://www.weimob.com/weisite/home?pid=242942&bid=25797&wechatid=fromUsername";
	}
	 */
	
	
}

