package edu.ecompus.core.util;

import java.io.IOException;
import java.util.Properties;

import org.springframework.core.io.support.PropertiesLoaderUtils;
/**
 * env.properties加载工具类
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public class EnvProperUtil extends PropertiesLoaderUtils {
	/**
	 * 服务端真实路径
	 */
	public static String webrealpath;
	
	private static Properties props = null;
	
	/**
	 * 初始化
	 */
	public static void initProps(){
		try
		{
			props = PropertiesLoaderUtils.loadAllProperties("env.properties");
		}catch (IOException e)
		{
			e.printStackTrace();
		}
	}
	
	/**
	 * 提取key配置值
	 * @param key
	 * @return
	 */
	public static String getSiteEnvValue(String key)
	{
		String value = "";
		if(props!=null){
			value = props.getProperty(key);
		}else{
			value = "";
		}
		
		return value;
	}
	
	/**
	 * 提取静态资源地址
	 * @return
	 */
	public static String getStaticUrl(){
		return getSiteEnvValue("static.server.url");
	}
	
	/**
	 * 提取网站资源地址
	 * @return
	 */
	public static String getWebUrl(){
		return getSiteEnvValue("site.server.url"); 
	}
	
}
