package edu.ecompus.core.service;


import edu.ecompus.core.dao.ML2GenericDao;

/**
 * Service基础实现类
 * 可以获得常用的增删查改操作
 * 未实现的方法有 子类各自实现
 * <p/>
 * Model : 代表数据库中的表 映射的Java对象类型
 * PK :代表对象的主键类型
 * 
 * 
 * @param <Model>
 * @param <PK>
 * Project:               E-COMPUS CORE
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-10-23 下午5:19:28
 */
public abstract class ML2GenerateServiceImpl<Model, PK> implements ML2GenerateService<Model, PK> {

	/**
     * 定义成抽象方法,由子类实现,完成dao的注入
     *
     * @return GenericDao实现类
     */
    public abstract ML2GenericDao<Model, PK> getDao();
	
	@Override
	public Model add(Model model) {
		getDao().create(model);
		return model;
	}

	@Override
	public void update(Model model) {
		getDao().update(model);
	}

	@Override
	public void delete(PK id) {
		getDao().deleteByPK(id);
	}

	@Override
	public Model getById(PK id) {
		return getDao().get(id);
	}


}
