package edu.ecompus.core.job;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;




/**
 * 任务线程类
 * 
 * 
 * Project:               E-COMPUS CORE
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-10-24 上午11:08:35
 */
public class ConvertJob {
	private static Logger logger = LoggerFactory.getLogger(ConvertJob.class);  
	
	/**任务 队列**/
	public static BlockingQueue<Runnable> queue = null;
	/**执行线程池**/
	private static ThreadPoolExecutor threadPool = null;
	//threadPool = new ThreadPoolExecutor(5, 10, 10, TimeUnit.SECONDS, queue);
	/**线程编号**/
	public static long threadId = 0;
	
	public static void init(){
		logger.info("初始化【转换】线程池...");
		queue = new LinkedBlockingQueue<Runnable>();
		//最小1,最大2,维护线程空间,5分钟
		threadPool = new ThreadPoolExecutor(1, 2, 5, TimeUnit.SECONDS, queue);
	}
	
	/**
	 * 添加转换任务
	 * @param run
	 */
	public static void addJob(ConvertRunnable run){
		if(threadPool!=null){
			if(isTaskExists(run.getUniqueKey())==false) threadPool.execute(run);
		}
	}
	
	
	/**
	 * 根据videoId判断任务是否已经存在
	 * @param videoId
	 * @return
	 */
	public static boolean isTaskExists(String key){
		for(Runnable r : queue){
			try{
				ConvertRunnable ra = (ConvertRunnable) r;
				if(ra.getUniqueKey().equals(key)) return true;
			}catch(Exception e){}
		}
		
		return false;
	}
}
