package edu.ecompus.core.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import edu.ecompus.core.util.HttpUtil;

/**
 * 页面性能拦截器
 * 
 * 
 * Project:               E-COMPUS CORE
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-10-23 下午5:35:08
 */
public class PerformanceHandlerInterceptor implements HandlerInterceptor {
	private static final Logger logger = LoggerFactory.getLogger(PerformanceHandlerInterceptor.class);
	private static final String START_TIME = "perf_start";
	
	@Override
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex)
			throws Exception {
		Long startTime = (Long)request.getAttribute(START_TIME);
		if (startTime != null)
		{
			long last = System.currentTimeMillis() - startTime.longValue();
			logger.info((new StringBuilder()).append("Request for URI: ").append(HttpUtil.getURL(request)).toString());
			logger.info((new StringBuilder()).append("Performace: ").append(last).append("ms.").toString());
		}

	}

	@Override
	public void postHandle(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse, Object obj, ModelAndView modelandview) throws Exception {
	}

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
		request.setAttribute(START_TIME, Long.valueOf(System.currentTimeMillis()));
		return true;
	}

}
