package edu.ecompus.core.filter;

import edu.ecompus.core.util.GZipUtil;


/**
 * 压缩后的Resonse内容
 * 
 * 
 * Project:               E-COMPUS CORE
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-10-24 上午11:07:24
 */
public class GZipResponseContent {
	private long lastModified;
	private byte data[];
	
	public GZipResponseContent(byte data[])
	{
		lastModified = System.currentTimeMillis();
		this.data = GZipUtil.gzip(data);
	}
	
	public long getLastModified()
	{
		return lastModified;
	}

	public byte[] getData()
	{
		return data;
	}
}
