package edu.ecompus.core.filter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEntry {
	private String url;
	@SuppressWarnings("unchecked")
	private Map parameters;
	private int parametersCount;
	private static final Logger logger = LoggerFactory.getLogger(CacheEntry.class);
	
	@SuppressWarnings("unchecked")
	public CacheEntry(String config)
	{
		parameters = new HashMap();
		logger.info((new StringBuilder()).append("Parse cache config: ").append(config).toString());
		String ss[] = config.trim().split("\\=");
		if (ss.length != 2)
			throw new IllegalArgumentException((new StringBuilder()).append("Illegal config: ").append(config).toString());
		url = ss[0].trim();
		if (url.equals(""))
			throw new IllegalArgumentException((new StringBuilder()).append("Illegal config: ").append(config).toString());
		String ps[] = ss[1].split("\\,");
		String arr$[] = ps;
		int len$ = arr$.length;
		for (int i$ = 0; i$ < len$; i$++)
		{
			String p = arr$[i$];
			addParameter(p);
		}

		parametersCount = parameters.size();
	}

	@SuppressWarnings("unchecked")
	private void addParameter(String p)
	{
		p = p.trim();
		String ss[] = p.split("[ ]+", 2);
		String param = ss[0];
		String value = null;
		if (ss.length == 2)
		{
			value = ss[1].trim();
			if (value.matches("\\\".*\\\""))
				value = value.substring(1, value.length() - 1);
		}
		parameters.put(param, value);
	}

	@SuppressWarnings("unchecked")
	public String buildKey(HttpServletRequest request)
	{
		if (!url.equals(request.getRequestURI()))
			return null;
		if (parametersCount == 0)
			return url;
		StringBuffer sb = new StringBuffer(256);
		sb.append(url).append('?');
		for (Iterator i$ = parameters.keySet().iterator(); i$.hasNext();)
		{
			String p = (String)i$.next();
			String value = request.getParameter(p);
			if (value != null)
			{
				sb.append(p).append('=').append(value).append('&');
			} else
			{
				String dv = (String)parameters.get(p);
				if (dv == null)
					return null;
				sb.append(p).append('=').append(dv).append('&');
			}
		}

		return sb.toString();
	}
}
