package edu.ecompus.core.filter;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

/**
 * 缓存定义编辑器
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public class CacheDefinitionEditor extends PropertyEditorSupport {
	
	@SuppressWarnings("unchecked")
	public void setAsText(String text) throws IllegalArgumentException
	{
		BufferedReader reader = new BufferedReader(new StringReader(text));
		List entries = new ArrayList();
		do
		{
			try
			{
				String s = reader.readLine();
				if (s == null)
					break;
				s = s.trim();
				if (!s.equals(""))
					entries.add(new CacheEntry(s));
				continue;
			}
			catch (IOException e) { }
			break;
		} while (true);
		setValue(new CacheDefinition((CacheEntry[])entries.toArray(new CacheEntry[0])));
	}
}
