package edu.ecompus.core.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

/**
 * 过滤器
 * 
 * 
 * Project:               E-COMPUS CORE
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-3-28 上午9:40:20
 */
public abstract class AbstractCacheFilter implements Filter, InitializingBean {
	protected static final Logger logger = LoggerFactory.getLogger(AbstractCacheFilter.class);
	
	private String contentType;
	private CacheDefinition cacheDefinition;
	
	public AbstractCacheFilter()
	{
		this.contentType = "text/html;charset=UTF-8";
	}
	
	public final void setContentType(String contentType)
	{
		this.contentType = contentType;
	}
	
	protected final String getContentType()
	{
		return this.contentType;
	}
	
	public final void setCacheDefinition(CacheDefinition cacheDefinition)
	{
		this.cacheDefinition = cacheDefinition;
	}
	
	protected final String getKey(HttpServletRequest httpRequest)
	{
		return cacheDefinition.getKey(httpRequest);
	}
	
	
	@Override
	public void destroy() {
	}

	@Override
	public void doFilter(ServletRequest arg0, ServletResponse arg1,
			FilterChain arg2) throws IOException, ServletException {
	}

	@Override
	public void init(FilterConfig arg0) throws ServletException {
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		if (cacheDefinition == null)
			throw new NullPointerException("Property cacheDefinition must be set.");
		if (contentType == null || contentType.trim().equals(""))
		{
			throw new NullPointerException("Property contentType is null or empty.");
		} else
		{
			contentType = contentType.trim();
			return;
		}

	}

}
