package edu.ecompus.core.cache.redis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import redis.clients.jedis.Jedis;

/**
 * RedisCache : redis 缓存 插件
 * 
 * 
 * Project:               E-COMPUS CORE
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-10-23 下午4:43:56
 */
@Component(value = "redisCache")
public class RedisCache {
	protected final Logger logger = LoggerFactory.getLogger(getClass());
	
	private int port = 6379;
    private String host = "127.0.0.1";
    private Jedis jedis = new Jedis(host, port);

    /**
     * 添加缓存值
     * @param key		缓存KEY
     * @param value		缓存值
     * @param seconds	有效时间
     * @return
     */
    public String cache(String key, String value, int seconds) {
    	logger.debug("Redis>添加缓存:"+key+",value="+value+",seconds="+seconds);
        String result = jedis.set(key, value);
        jedis.expire(key, seconds);
        return result;
    }

    /**
     * 读取缓存值
     * @param key
     * @return
     */
    public String get(String key) {
    	logger.debug("Redis>读取缓存:"+key);
        return jedis.get(key);
    }
}
