package edu.ecompus.core.cache.memcached;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;


import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractCacheManager;

/**
 * Memcache缓存管理器
 * 
 * 
 * Project:               E-COMPUS CORE
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-10-23 下午4:53:43
 */
public class MemcachedCacheManager extends AbstractCacheManager {
	private ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();  
    private Map<String, Integer> expireMap = new HashMap<String, Integer>();  
  
	
    public MemcachedCacheManager()  
    {  
    }
    
	@Override
	protected Collection<? extends Cache> loadCaches() {
		Collection<Cache> values = cacheMap.values();  
        return values;
	}
	
	/**
	 * Specify the collection of Cache instances to use for this CacheManager.
	 */
	public void setCaches(Collection<? extends Cache> caches) {
		for(Cache c : caches){
			cacheMap.put(c.getName(), c);
		}
	}
	
	@Override  
    public Cache getCache(String name)  
    {  
        Cache cache = cacheMap.get(name);  
        if (cache == null)  
        {  
            Integer expire = expireMap.get(name);  
            if (expire == null)  
            {  
                expire = 0;  
                expireMap.put(name, expire);  
            }  
              
            cache = new MemcachedCache();  
            cacheMap.put(name, cache);  
        }  
        return cache;  
    }  
  
  
    public void setConfigMap(Map<String, Integer> configMap)  
    {  
        this.expireMap = configMap;  
    }

}
