/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.util;

import edu.ecompus.core.common.exception.ML2BaseException;
import edu.ecompus.core.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class FormUploadRequest {
    HttpServletRequest request;
    String field;
    long MaxSize = 314572800L;
    String allowdType = "";
    String fileName;
    String uploadDir;

    public FormUploadRequest(HttpServletRequest request, String field) {
        this.request = request;
        this.field = field;
        this.uploadDir = "";
    }

    public String upload() throws Exception, ML2BaseException {
        MultipartHttpServletRequest multipart = (MultipartHttpServletRequest)this.request;
        InputStream input = null;
        if (multipart.getFile(this.field) == null) {
            return "";
        }
        input = multipart.getFile(this.field).getInputStream();
        CommonsMultipartFile commonFile = (CommonsMultipartFile)multipart.getFile(this.field);
        String fileExtension = FileUtil.getExtension(commonFile.getOriginalFilename()).toLowerCase();
        if ("".equals(fileExtension)) {
            throw new ML2BaseException("FormUploadRequestError001", "\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (commonFile.getSize() > this.MaxSize) {
            throw new ML2BaseException("FormUploadRequestError002", "\u4e0a\u4f20\u7684\u6587\u4ef6\u8d85\u8fc7\u6700\u5927\u6587\u4ef6\u7684\u9650\u5236");
        }
        String[] allowedTypes = StringUtils.split((String)this.allowdType, (String)",");
        boolean allowed = false;
        for (int i = 0; i < allowedTypes.length; ++i) {
            if (!fileExtension.equals(allowedTypes[i])) continue;
            allowed = true;
            break;
        }
        if (!allowed) {
            throw new ML2BaseException("FormUploadRequestError003", "\u672a\u77e5\u7684\u6587\u4ef6\u7c7b:" + fileExtension);
        }
        String _fileName = this.fileName + "." + fileExtension;
        File uploadFile = new File(this.uploadDir + File.separator + _fileName);
        uploadFile.getParentFile().mkdirs();
        FileOutputStream bos = new FileOutputStream(uploadFile);
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        while ((bytesRead = input.read(buffer, 0, 8192)) != -1) {
            ((OutputStream)bos).write(buffer, 0, bytesRead);
        }
        ((OutputStream)bos).close();
        input.close();
        return uploadFile.getAbsolutePath();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public long getMaxSize() {
        return this.MaxSize;
    }

    public void setMaxSize(long maxSize) {
        this.MaxSize = maxSize;
    }

    public String getAllowdType() {
        return this.allowdType;
    }

    public void setAllowdType(String allowdType) {
        this.allowdType = allowdType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getUploadDir() {
        return this.uploadDir;
    }

    public void setUploadDir(String uploadDir) {
        this.uploadDir = uploadDir;
    }
}

