/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.filter;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEntry {
    private String url;
    private Map parameters = new HashMap();
    private int parametersCount;
    private static final Logger logger = LoggerFactory.getLogger(CacheEntry.class);

    public CacheEntry(String config) {
        String[] ps;
        logger.info("Parse cache config: " + config);
        String[] ss = config.trim().split("\\=");
        if (ss.length != 2) {
            throw new IllegalArgumentException("Illegal config: " + config);
        }
        this.url = ss[0].trim();
        if (this.url.equals("")) {
            throw new IllegalArgumentException("Illegal config: " + config);
        }
        for (String p : ps = ss[1].split("\\,")) {
            this.addParameter(p);
        }
        this.parametersCount = this.parameters.size();
    }

    private void addParameter(String p) {
        p = p.trim();
        String[] ss = p.split("[ ]+", 2);
        String param = ss[0];
        String value = null;
        if (ss.length == 2 && (value = ss[1].trim()).matches("\\\".*\\\"")) {
            value = value.substring(1, value.length() - 1);
        }
        this.parameters.put(param, value);
    }

    public String buildKey(HttpServletRequest request) {
        if (!this.url.equals(request.getRequestURI())) {
            return null;
        }
        if (this.parametersCount == 0) {
            return this.url;
        }
        StringBuffer sb = new StringBuffer(256);
        sb.append(this.url).append('?');
        for (String p : this.parameters.keySet()) {
            String value = request.getParameter(p);
            if (value != null) {
                sb.append(p).append('=').append(value).append('&');
                continue;
            }
            String dv = (String)this.parameters.get(p);
            if (dv == null) {
                return null;
            }
            sb.append(p).append('=').append(dv).append('&');
        }
        return sb.toString();
    }
}

