/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.entity;

import java.io.Serializable;

public class Page
implements Serializable {
    private static final long serialVersionUID = -4298760336080849230L;
    public static final int DEFAULT_PAGE_SIZE = 10;
    private int pageIndex;
    private int pageSize;
    private int totalCount;
    private int pageCount;

    public Page(int pageIndex, int pageSize) {
        if (pageIndex < 1) {
            pageIndex = 1;
        }
        if (pageSize < 1) {
            pageSize = 1;
        }
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public Page(int pageIndex) {
        this(pageIndex, 10);
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getFirstResult() {
        return (this.pageIndex - 1) * this.pageSize;
    }

    public boolean getHasPrevious() {
        return this.pageIndex > 1;
    }

    public boolean getHasNext() {
        return this.pageIndex < this.pageCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
        this.pageCount = totalCount / this.pageSize + (totalCount % this.pageSize != 0 ? 1 : 0);
        if (totalCount == 0 ? this.pageIndex != 1 : this.pageIndex > this.pageCount) {
            throw new IndexOutOfBoundsException("Page index out of range.");
        }
    }

    public boolean isEmpty() {
        return this.totalCount == 0;
    }
}

