package edu.ecompus.core.util;

import java.io.File;

import com.oreilly.servlet.multipart.FileRenamePolicy;

public class RandomFileRenamePolicy implements FileRenamePolicy {
	/**
	 * 目标路径
	 */
	private String targetPath;
	
	/**文件原名**/
	private String oldFileName;
	
	public RandomFileRenamePolicy(String targetPath){
		this.targetPath = targetPath;	
		if(this.targetPath!=null && !"".equals(this.targetPath)){
			File f1 = new File(targetPath);
			if (!f1.exists()) {
				f1.mkdirs();
			}
			f1=null;
		}
		
	}

	/**
	 * 重载该方法,生成GUID文件
	 */
	public File rename(File file) {
		this.oldFileName = file.getName();
		
		if(this.targetPath!=null && !"".equals(this.targetPath)){
			file = new File(this.targetPath, getNewFileName(file.getName()));
		}else{
			file = new File(file.getParent(), getNewFileName(file.getName()));
		}
		return file;
	}

	/**
	 * 生成新的文件名
	 * @param fileName
	 * @return
	 */
	public String getNewFileName(String fileName) {
		String fType = getFiletype(fileName); // 文件类型
		String ffrontname = getFilefrontname(fileName); // 文件名前缀
		// 替换前缀名中包含的特殊字符，视具体情况而定
		ffrontname = ffrontname.replace(',', '_');
		ffrontname = ffrontname.replace('#', '_');
		ffrontname = ffrontname.replace('&', '_');
		ffrontname = ffrontname.replace('%', '％');
		
		// String newFileName = UUID.randomUUID() + "." + fType;
		String newFileName = "S"+System.currentTimeMillis() + "." + fType;
		return newFileName;
	}

	/**
	 * 取文件名后缀(扩展名) 用于COS组件
	 * 
	 * @param fileName
	 * @return
	 */
	public static String getFiletype(String fileName) {
		String type = "";
		if (fileName == null || fileName.equals("")) {
			return type;
		}

		int position = fileName.lastIndexOf(".");
		if (position != -1) {
			type = fileName.substring(position + 1, fileName.length());
		}
		return type;
	}

	/**
	 * 取文件名(.号以前)
	 * 
	 * @param fileName
	 * @return
	 */
	public static String getFilefrontname(String fileName) {
		String name = "";
		if (fileName == null || fileName.equals("")) {
			return name;
		}
		// 最后一个.
		int position = fileName.lastIndexOf(".");
		if (position != -1) {
			name = fileName.substring(0, position);
		}

		String newname = "";
		newname = name.trim().replaceAll(" ", "");
		newname = newname.replaceAll("%", "_");
		newname = newname.replaceAll("\\+", "_"); // + 模式匹配规则表达式，需要用\转义
		return newname;
	}

	public String getOldFileName() {
		return oldFileName;
	}

	public void setOldFileName(String oldFileName) {
		this.oldFileName = oldFileName;
	}

}
