package edu.ecompus.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import edu.ecompus.core.common.exception.ML2BaseException;



/**
 * 文件上传页面,提取处理
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public class FormUploadRequest {
	/**
	 * 请求页面
	 */
	HttpServletRequest request;
	/**
	 * 请求表单中,type="file"的ID/NAME名
	 */
	String field;
	
	/**
	 * 最大上传文件大小,默认30M
	 */
	long MaxSize = 300*1024*1024;
	
	/**
	 * 允许上传的扩展名,以","分开
	 */
	String allowdType = "";
	
	/**
	 * 保存的文件名
	 */
	String fileName;
	
	/**
	 * 上传保存的路径
	 */
	String uploadDir;
	
	public FormUploadRequest(HttpServletRequest request, String field){
		this.request = request;
		//
		this.field = field;
		//
		this.uploadDir = "";
	}
	
	/**
	 * 保存上传的视频
	 * @param request
	 * @return 返回绝对路径的视频
	 * @throws Exception
	 */
	public String upload() throws Exception,ML2BaseException {
		MultipartHttpServletRequest multipart = (MultipartHttpServletRequest) request;
		InputStream input = null;
		if(multipart.getFile(this.field)!=null){
			input = multipart.getFile(this.field).getInputStream();
		}else{
			return "";
		}
			
		CommonsMultipartFile commonFile = (CommonsMultipartFile) multipart.getFile(this.field);
		//文件扩展名
		String fileExtension = FileUtil.getExtension(commonFile.getOriginalFilename()).toLowerCase();
		//扩展名异常,跳出异常
		if ("".equals(fileExtension)) {
			throw new ML2BaseException("FormUploadRequestError001", "上传的文件不可以为空");
		}
		//判断文件大小
		if (commonFile.getSize() > MaxSize) {
			throw new ML2BaseException("FormUploadRequestError002", "上传的文件超过最大文件的限制");
		}
		//判断允许上传的文件类型
		String allowedTypes[] = StringUtils.split(allowdType, ",");
		boolean allowed = false;
		for (int i = 0; i < allowedTypes.length; i++) {
			if (!fileExtension.equals(allowedTypes[i]))
			continue;
			allowed = true;
			break;
		}
		
		// 如果是不允许上传的文件类型，则进行消息处理
		if (!allowed) {
			throw new ML2BaseException("FormUploadRequestError003", "未知的文件类:"+fileExtension);
		}
		
		
		/**
		 * 保存的文件名
		 */
		String _fileName = this.fileName + "." + fileExtension;
		File uploadFile = new File(uploadDir + File.separator + _fileName);
		//创建目录
		uploadFile.getParentFile().mkdirs();
		OutputStream bos = new FileOutputStream(uploadFile);
		int bytesRead = 0;
		byte buffer[] = new byte[8192];
		while ((bytesRead = input.read(buffer, 0, 8192)) != -1)
			bos.write(buffer, 0, bytesRead);
		bos.close();
		input.close();
		
		//返回上传文件的绝对路径
		return uploadFile.getAbsolutePath();
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}

	public String getField() {
		return field;
	}

	public void setField(String field) {
		this.field = field;
	}

	public long getMaxSize() {
		return MaxSize;
	}

	public void setMaxSize(long maxSize) {
		MaxSize = maxSize;
	}

	public String getAllowdType() {
		return allowdType;
	}

	public void setAllowdType(String allowdType) {
		this.allowdType = allowdType;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getUploadDir() {
		return uploadDir;
	}

	public void setUploadDir(String uploadDir) {
		this.uploadDir = uploadDir;
	}
	
}
