package edu.ecompus.core.util;

import java.io.File;


import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

import com.oreilly.servlet.MultipartRequest;

/**
 * Flash SWF 上传
 * <li>2014.2.7 获取源文件名getSourceFileName
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0.1
 * @since 1.0
 */
public class FlashUploadRequest {
	/**
	 * 请求页面
	 */
	HttpServletRequest request;
	
	/**
	 * 最大上传文件大小,默认300M
	 */
	int MaxSize = 300*1024*1024;
	
	/**
	 * 上传的文件名
	 */
	String fileName;
	
	/**
	 * 上传保存的路径
	 */
	String uploadDir;
	
	/**
	 * 重命名规则
	 */
	RandomFileRenamePolicy cospolicy;
	
	public FlashUploadRequest(HttpServletRequest request){
		this.request = request;
		//
		this.uploadDir = "";
	}
	
	/**
	 * 保存上传的视频
	 * @return 返回File实体
	 * @throws Exception
	 */
	@SuppressWarnings("rawtypes")
	public File upload() throws Exception {
		cospolicy = new RandomFileRenamePolicy(this.uploadDir);
		
		//COS处理文件上传
		MultipartRequest multi =  new MultipartRequest(request, uploadDir, MaxSize, "UTF-8", cospolicy);
		
		//
		Enumeration files = multi.getFileNames();
		//循环上传的文件列表,
		while (files.hasMoreElements()) {
	          String name = (String)files.nextElement();
	          //已上传的文件
	          File f = multi.getFile(name);
	          if(f.isFile() && f.exists()){
	        	  this.fileName = cospolicy.getOldFileName();
	        	  return f;
	          }
		}
		
		return null;
	}


	public int getMaxSize() {
		return MaxSize;
	}

	public void setMaxSize(int maxSize) {
		MaxSize = maxSize;
	}


	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getUploadDir() {
		return uploadDir;
	}

	public void setUploadDir(String uploadDir) {
		this.uploadDir = uploadDir;
		
		if(this.uploadDir!=null && !"".equals(this.uploadDir)){
			File dir = new File(this.uploadDir);
			if(dir.isDirectory() && !dir.exists()){
				dir.mkdirs();
			}
		}
		
	}
	
	/**
	 * 读取源文件文件名
	 * @return
	 */
	public String getSourceFileName(){
		if(cospolicy!=null){
			return cospolicy.getOldFileName();
		}
		
		return null;
	}


	
}
