package edu.ecompus.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;


/**
 * 文件工具类
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public class FileUtil {
	/**
	 * 移除文件
	 * @param file
	 */
	public static void removeFile(File file)
	{
		for (int maxTry = 3; maxTry > 0;)
		{
			maxTry--;
			if (file.isFile())
			{
				if (file.delete())
					return;
			} else
			{
				return;
			}
		}
	}
	/**
	 * 删除文件
	 * @param filePathAndName
	 * @return
	 */
	public static boolean delFile(String filePathAndName)
	{
		boolean ret = false;
		try
		{
			(new File(filePathAndName.toString())).delete();
			ret = true;
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return ret;
	}
	
	/**
	 * 删除整个目录文件
	 * @param dir
	 * @return
	 */
	public static boolean delFiles(String dir)
	{
		boolean ret = false;
		try
		{
			File filePath = new File(dir);
			String files[] = filePath.list();
			int i = 0;
			for (i = 0; i < files.length; i++)
				(new File((new StringBuilder()).append(dir).append(File.separator).append(files[i]).toString())).delete();

			ret = true;
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return ret;
	}

	/**
	 * 判断文件是否存在
	 * @param filename
	 * @return
	 */
	public static boolean isExist(String filename)
	{
		boolean ret = false;
		try
		{
			File file = new File(filename.toString());
			if (file.exists())
				ret = true;
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return ret;
	}

	/**
	 * 上传文件
	 * @param file
	 * @param dir
	 * @param filename
	 * @return
	 */
	public static boolean uploadFile(File file, String dir, String filename)
	{
		boolean ret = false;
		try
		{
			if (file != null)
			{
				File filePath = new File(dir);
				if (!filePath.exists())
					filePath.mkdir();
				String target = (new StringBuilder()).append(dir).append(filename).toString();
				FileOutputStream outputStream = new FileOutputStream(target);
				FileInputStream fileIn = new FileInputStream(file);
				byte buffer[] = new byte[1024];
				int len;
				while ((len = fileIn.read(buffer)) > 0) 
					outputStream.write(buffer, 0, len);
				fileIn.close();
				outputStream.close();
				ret = true;
			}
		}
		catch (Exception ex) { }
		return ret;
	}

	/**
	 * 保存文件
	 * @param stream
	 * @param path
	 * @param filename
	 * @throws IOException
	 */
	@SuppressWarnings("unused")
	public static void SaveFileFromInputStream(InputStream stream, String path, String filename)
		throws IOException
	{
		FileOutputStream fs = new FileOutputStream((new StringBuilder()).append(path).append(File.separator).append(filename).toString());
		byte buffer[] = new byte[0x100000];
		int bytesum = 0;
		for (int byteread = 0; (byteread = stream.read(buffer)) != -1;)
		{
			bytesum += byteread;
			fs.write(buffer, 0, byteread);
			fs.flush();
		}

		fs.close();
		stream.close();
	}
	
	/**
	 * 读取文件到流
	 * @param file
	 * @param output
	 * @throws IOException
	 */
	public static void readFile(File file, OutputStream output) throws IOException
	{
		FileInputStream input;
		FileChannel fc;
		input = null;
		fc = null;
		try{
			input = new FileInputStream(file);
			fc = input.getChannel();
			ByteBuffer buffer = ByteBuffer.allocate(4096);
			do
			{
				buffer.clear();
				int n = fc.read(buffer);
				if (n == -1)
					break;
				output.write(buffer.array(), 0, buffer.position());
			} while (true);
		}catch(Exception exception){
		}finally{
			if (fc != null){
				try
				{
					fc.close();
				}
				catch (IOException e) { }
			}
				
			if (input != null){
				try
				{
					input.close();
				}
				catch (IOException e) { }
			}
		}
	}
	
	/**
	 * 写文件
	 * @param file
	 * @param data
	 * @throws IOException
	 */
	public static void writeFile(File file, byte data[])
		throws IOException
	{
		FileOutputStream output;
		FileChannel fc;
		int MAX_BUFFER_SIZE = 4096;
		output = null;
		fc = null;
		try{
			output = new FileOutputStream(file);
			fc = output.getChannel();
			ByteBuffer buffer = ByteBuffer.allocate(MAX_BUFFER_SIZE);
			for (int offset = 0; offset < data.length;)
			{
				buffer.clear();
				int len = data.length - offset;
				if (len > MAX_BUFFER_SIZE)
					len = MAX_BUFFER_SIZE;
				buffer.put(data, offset, len);
				offset += len;
				buffer.flip();
				fc.write(buffer);
			}
		}catch(Exception exception){
		}finally{
			if (fc != null)
				try
				{
					fc.close();
				}
				catch (IOException e) { }
			if (output != null)
				try
				{
					output.close();
				}
				catch (IOException e) { }
		}
	}
	
	/**
	 * 取文件扩展名
	 * @param fileName
	 * @return
	 */
	public static String getExtension(String fileName)
	{
		int index = fileName.lastIndexOf(".");
		if (index != -1)
			return fileName.substring(index + 1, fileName.length());
		else
			return fileName;
	}

	/**
	 * 提取文件名(不包含扩展名)
	 * @param fileName
	 * @return
	 */
	public static String getFileNameNotExtension(String fileName)
	{
		int index = fileName.lastIndexOf(".");
		if (index != -1)
			return fileName.substring(0, index);
		else
			return fileName;
	}

	/**
	 * 生成随机文件名
	 * @return
	 */
	public static String getFileNameRandom()
	{
		String format = "yyyyMMddHHmmss";
		Random r = new Random();
		int rannum = (int)(r.nextDouble() * 9000D) + 1000;
		String name = (new SimpleDateFormat(format)).format(new Date());
		name = (new StringBuilder()).append(name).append(rannum).toString();
		return name;
	}
	
	
	/**
	 * 生成Dir路径
	 * @param dir
	 */
	public static void createDirs(String dir){
		File fdir = new File(dir);
		
		createDirs(fdir);
	}
	
	/**
	 * 创建Dir
	 * @param dir
	 */
	public static void createDirs(File dir){
		dir.mkdirs();
	}
	
	/**
	 * 另存为
	 * @param sourcefile	源文件
	 * @param targerfile	目标文件
	 */
	public static void saveAs(String sourcefile, String targerfile) throws Exception {
		InputStreamReader in = new InputStreamReader(
				new FileInputStream(sourcefile));//按原文件的编码方式进行读取文件信息  
		OutputStreamWriter out = new OutputStreamWriter(  
                new FileOutputStream(targerfile),"utf-8");//转换为自己想要的编码格  
		char[] cbuf = new char[1024];  
        int n;  
        while((n=in.read(cbuf))!=-1){  
            out.write(cbuf, 0, n);  
        }  
        in.close();  
        out.close();
	}
	
	/**
	 * 遍历dir目录下所有fileTypes文件（包含其下子目录）
	 * @param dir
	 * @param fileTypes			.gif,.png,.jpg,.jpeg,.bmp
	 * @return
	 */
	public static List<File> getFiles(String dir, String fileTypes, List<File> files){
		File realFile = new File(dir);
		if (realFile.isDirectory()) {
			//读取目录下所有的文件
			File[] subfiles = realFile.listFiles();
			//System.out.println("遍历："+realpath);
			for(File file :subfiles ){
				if(file.isDirectory()){
					getFiles(file.getAbsolutePath(),fileTypes, files);
				}else{
					String fileT = getExtension(file.getName());
					//判断扩展名是否包含在fileTypes里面
					if(fileTypes!=null && fileTypes.indexOf(fileT.toLowerCase())>=0) {
						files.add(file);
					}
				}
			}
		}
		
		return files;
	}
	
	
	public static void main(String args[])
	{
		String dir = "E:\\婚礼";
		List<File> filelist = getFiles(dir, ".png,.jpg", new ArrayList());
		for(File file : filelist){
			System.out.println(file.getPath());
		}
	}
	
}
