package edu.ecompus.core.util;

import java.math.BigInteger;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

/**
 * DES加密工具
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public class DesCryptUtil {
	private static String Algorithm = "DES";
	static boolean debug = false;
	/**
	 * 公钥
	 */
	public static final String PUBLICKEY = "@janny-shao";
	
	public byte[] encode(byte input[], byte key[]) throws Exception
	{
		SecretKey deskey = new SecretKeySpec(key, Algorithm);
		if (debug)
		{
			System.out.println((new StringBuilder()).append("加密前的二进串:").append(byte2hex(input)).toString());
			System.out.println((new StringBuilder()).append("加密前的字符串:").append(new String(input, "ISO-8859-1")).toString());
		}
		Cipher c1 = Cipher.getInstance(Algorithm);
		c1.init(1, deskey);
		byte cipherByte[] = c1.doFinal(input);
		if (debug)
		{
			System.out.println((new StringBuilder()).append("加密后的二进串:").append(byte2hex(cipherByte)).toString());
			System.out.println((new StringBuilder()).append("加密后的字符串:").append(new String(cipherByte, "ISO-8859-1")).toString());
		}
		return cipherByte;
	}
	
	public byte[] decode(byte input[], byte key[])
		throws Exception
	{
		SecretKey deskey = new SecretKeySpec(key, Algorithm);
		if (debug)
		{
			System.out.println((new StringBuilder()).append("解密前的二进串:").append(byte2hex(input)).toString());
			System.out.println((new StringBuilder()).append("解密前的字符串:").append(new String(input, "ISO-8859-1")).toString());
		}
		Cipher c1 = Cipher.getInstance(Algorithm);
		c1.init(2, deskey);
		byte clearByte[] = c1.doFinal(input);
		if (debug)
		{
			System.out.println((new StringBuilder()).append("解密后的二进串:").append(byte2hex(clearByte)).toString());
			System.out.println((new StringBuilder()).append("解密后的字符串:").append(new String(clearByte, "ISO-8859-1")).toString());
		}
		return clearByte;
	}
	
	public String byte2hex(byte b[])
	{
		String hs = "";
		String stmp = "";
		for (int n = 0; n < b.length; n++)
		{
			stmp = Integer.toHexString(b[n] & 0xff);
			if (stmp.length() == 1)
				hs = (new StringBuilder()).append(hs).append("0").append(stmp).toString();
			else
				hs = (new StringBuilder()).append(hs).append(stmp).toString();
			if (n < b.length - 1)
				hs = (new StringBuilder()).append(hs).append(":").toString();
		}
	
		return hs.toUpperCase();
	}
	
	public String encrypt(String value) throws Exception
	{
		byte temp[] = encode(value.getBytes("GBK"), "topcheer".getBytes());
		BigInteger bigInt = new BigInteger(temp);
		return new String(bigInt.toString());
	}
	
	public String decrypt(String value) throws Exception
	{
		BigInteger bigInt = new BigInteger(value);
		byte b[] = bigInt.toByteArray();
		byte temp[] = decode(b, "topcheer".getBytes());
		return new String(temp, "GBK");
	}
	
		
}
