package edu.ecompus.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Cookie管理工具
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public class CookieUtil {
	
	/**
	 * 编码
	 * @param s
	 * @return
	 * @throws UnsupportedEncodingException
	 */
	@SuppressWarnings("unused")
	private static String encode(String s) throws UnsupportedEncodingException
	{
		return URLEncoder.encode(s, "UTF-8");
	}

	/**
	 * 解码
	 * @param s
	 * @return
	 * @throws UnsupportedEncodingException
	 */
	@SuppressWarnings("unused")
	private static String decode(String s) throws UnsupportedEncodingException
	{
		return URLDecoder.decode(s, "UTF-8");
	}
	
	/**
	 * 读取cookie
	 * @param request
	 * @param name
	 * @return
	 */
	public static Cookie getCookie(HttpServletRequest request, String name)
	{
		Cookie cookies[] = request.getCookies();
		if (cookies == null || name == null || name.length() == 0)
			return null;
		for (int i = 0; i < cookies.length; i++)
			if (name.equals(cookies[i].getName()))
				return cookies[i];

		return null;
	}
	
	/**
	 * 删除cookie
	 * @param request
	 * @param response
	 * @param cookie
	 */
	public static void deleteCookie(HttpServletRequest request, HttpServletResponse response, Cookie cookie)
	{
		if (cookie != null)
		{
			cookie.setPath(getPath(request));
			cookie.setValue("");
			cookie.setMaxAge(0);
			response.addCookie(cookie);
		}
	}

	/**
	 * 保存cookie
	 * @param request
	 * @param response
	 * @param name
	 * @param value
	 */
	public static void setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value)
	{
		setCookie(request, response, name, value, 0x1e13380);
	}
	
	/**
	 * 保存cookie
	 * @param request
	 * @param response
	 * @param name
	 * @param value
	 * @param maxAge	cookie存放的时间(以秒为单位,假如存放三天,即3*24*60*60; 如果值为0,cookie将随浏览器关闭而清除)
	 */
	public static void setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge)
	{
		Cookie cookie = new Cookie(name, value != null ? value : "");
		cookie.setMaxAge(maxAge);
		cookie.setPath(getPath(request));
		response.addCookie(cookie);
	}
	
	/**
	 * 读取路径
	 * @param request
	 * @return
	 */
	private static String getPath(HttpServletRequest request)
	{
		String path = request.getContextPath();
		return path != null && path.length() != 0 ? path : "/";
	}
}
