package edu.ecompus.core.util;

import javax.servlet.http.HttpServletRequest;

/**
 * 和浏览器有关的工具类
 * 
 * 
 * Project:               E-COMPUS CORE
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-3-28 上午9:43:56
 */
public class BrowserUtils {
	/**
	 * 判断是否为IE浏览器
	 */
	public static boolean isIE(HttpServletRequest request) {
		String agent = getAgent(request);
		if (null != agent && -1 != agent.indexOf("MSIE")) {
			return true;
		}
		return false;
	}

	/**
	 * 判断是否为FireFox浏览器
	 */
	public static boolean isMozilla(HttpServletRequest request) {
		String agent = getAgent(request);
		if (null != agent && -1 != agent.indexOf("Mozilla")) {
			return true;
		}
		return false;
	}

	/**
	 * 是否为Chrome或者Safari
	 */
	public static boolean isWebKit(HttpServletRequest request) {
		String agent = getAgent(request);
		if (null != agent && -1 != agent.indexOf("WebKit")) {
			return true;
		}
		return false;
	}

	/**
	 * 获取浏览器USER-AGENT
	 */
	public static String getAgent(HttpServletRequest request) {
		String agent = request.getHeader("USER-AGENT");
		return agent;
	}
}
