package edu.ecompus.core.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import edu.ecompus.core.jmx.ML2Sampler;
import edu.ecompus.core.util.HttpUtil;

/**
 * MINILIVE2 高性能过滤器
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public class PerformanceFilter implements Filter {
	private static final Logger logger = LoggerFactory.getLogger(PerformanceFilter.class);
	
	@SuppressWarnings("unchecked")
	public static final ThreadLocal businessPerf = new ThreadLocal();
	
	@SuppressWarnings("unchecked")
	public static final ThreadLocal daoPerf = new ThreadLocal();
	private static final String START_TIME = "ST_PERF_FILTER";
	
	private ML2Sampler httpSampler;
	private ML2Sampler businessSampler;
	private ML2Sampler daoSampler;
	
	@Override
	public void destroy() {
	}

	@SuppressWarnings("unchecked")
	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
		String url;
		url = HttpUtil.getURL((HttpServletRequest)request);
		if (url.endsWith("/checkState"))
		{
			chain.doFilter(request, response);
			return;
		}
		
		request.setAttribute(START_TIME, new Long(System.currentTimeMillis()));
		try{
			businessPerf.set(new Long(0L));
			daoPerf.set(new Long(0L));
			chain.doFilter(request, response);
			long httpTime = System.currentTimeMillis() - ((Long)request.getAttribute(START_TIME)).longValue();
			long businessTime = ((Long)businessPerf.get()).longValue();
			long daoTime = ((Long)daoPerf.get()).longValue();
			long businessPercent = httpTime != 0L ? (businessTime * 100L) / httpTime : 0L;
			long daoPercent = httpTime != 0L ? (daoTime * 100L) / httpTime : 0L;
			httpSampler.sample(httpTime);
			businessSampler.sample(businessTime);
			daoSampler.sample(daoTime);
			logger.info((new StringBuilder()).append(url).append(" execution: ").append(httpTime).append("ms.").toString());
			logger.info((new StringBuilder()).append("Business execution: ").append(businessTime).append("ms, ").append(businessPercent).append("%").toString());
			logger.info((new StringBuilder()).append("Dao execution: ").append(daoTime).append("ms, ").append(daoPercent).append("%").toString());
			businessPerf.remove();
			daoPerf.remove();
		}catch(Exception exception){
			long httpTime = System.currentTimeMillis() - ((Long)request.getAttribute(START_TIME)).longValue();
			long businessTime = ((Long)businessPerf.get()).longValue();
			long daoTime = ((Long)daoPerf.get()).longValue();
			long businessPercent = httpTime != 0L ? (businessTime * 100L) / httpTime : 0L;
			long daoPercent = httpTime != 0L ? (daoTime * 100L) / httpTime : 0L;
			httpSampler.sample(httpTime);
			businessSampler.sample(businessTime);
			daoSampler.sample(daoTime);
			logger.info((new StringBuilder()).append(url).append(" execution: ").append(httpTime).append("ms.").toString());
			logger.info((new StringBuilder()).append("Business execution: ").append(businessTime).append("ms, ").append(businessPercent).append("%").toString());
			logger.info((new StringBuilder()).append("Dao execution: ").append(daoTime).append("ms, ").append(daoPercent).append("%").toString());
			businessPerf.remove();
			daoPerf.remove();
		}

	}

	@Override
	public void init(FilterConfig arg0) throws ServletException {
	}


	public void setHttpSampler(ML2Sampler httpSampler) {
		this.httpSampler = httpSampler;
	}


	public void setBusinessSampler(ML2Sampler businessSampler) {
		this.businessSampler = businessSampler;
	}


	public void setDaoSampler(ML2Sampler daoSampler) {
		this.daoSampler = daoSampler;
	}
	
	
	

}
