package edu.ecompus.core.filter;

import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

/**
 * 解决Hibernate的Write operations are not allowed in read-only mode (FlushMode.NEVER/MANUAL): Turn your Session into FlushMode.COMMIT/AUTO or remove ‘readOnly’ marker from transaction definition.
 * <p>
 * 配置web.xml：
 * <filter>
	    <filter-name>hibernateFilter</filter-name>
	    <filter-class>edu.ecompus.core.filter.ML2OpenSessionInViewFilter</filter-class>
	    <init-param>
	        <param-name>singleSession</param-name>
	        <param-value>true</param-value>
	    </init-param>
	</filter>
	<filter-mapping>  
	    <filter-name>hibernateFilter</filter-name>   
	    <url-pattern>/*</url-pattern>  
	</filter-mapping>
 * </p>
 * <p>
 * 
 * 
 * Project:               E-COMPUS CORE
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-3-28 上午9:41:38
 */
public class ML2OpenSessionInViewFilter extends
		org.springframework.orm.hibernate3.support.OpenSessionInViewFilter {
	protected Session getSession(SessionFactory sessionFactory)
            throws DataAccessResourceFailureException {
        Session session = SessionFactoryUtils.getSession(sessionFactory, true);
        session.setFlushMode(FlushMode.COMMIT);
        return session;
    }
 
    protected void closeSession(Session session, SessionFactory factory) {
        session.flush();
        super.closeSession(session, factory);
    }
}
