package edu.ecompus.core.filter;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

/**
 * Request请求工厂
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
public class HttpServletRequestFactory {
	@SuppressWarnings("unchecked")
	private static final Class PROXY_INTERFACES[] = { HttpServletRequest.class };
	
	@SuppressWarnings("unchecked")
	public static HttpServletRequest create(final String uri,  final Map parameters)
	{
		
		return (HttpServletRequest)Proxy.newProxyInstance(HttpServletRequestFactory.class.getClassLoader(), PROXY_INTERFACES, 
				new InvocationHandler() {
					public Object invoke(Object proxy, Method method, Object args[]) throws Throwable
					{
						String methodName = method.getName();
						if (methodName.equals("getRequestURI"))
							return uri;
						if (methodName.equals("getParameter"))
							return parameters.get(args[0]);
						else
							throw new UnsupportedOperationException((new StringBuilder()).append("Method ").append(methodName).append(" are not supported.").toString());
					}
		});
	}
}
