package edu.ecompus.core.filter;

import edu.ecompus.core.util.GZipUtil;


/**
 * 压缩后的Resonse内容
 * @author Janny
 *
 */
public class GZipResponseContent {
	private long lastModified;
	private byte data[];
	
	public GZipResponseContent(byte data[])
	{
		lastModified = System.currentTimeMillis();
		this.data = GZipUtil.gzip(data);
	}
	
	public long getLastModified()
	{
		return lastModified;
	}

	public byte[] getData()
	{
		return data;
	}
}
