package edu.ecompus.core.dao.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.criterion.Projections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import edu.ecompus.core.entity.Page;

/**
 * 
 * 
 * 
 * Project:               E-COMPUS CORE
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-3-28 上午9:39:00
 */
public class PaginationCriteria {
	private static final Logger logger = LoggerFactory.getLogger(PaginationCriteria.class);
	private static Field orderEntriesField = getField(Criteria.class, "orderEntries");
	
	@SuppressWarnings("unchecked")
	public static List query(Criteria c, Page page)
	{
		List _old_orderEntries = (List)getFieldValue(orderEntriesField, c);
		boolean restore = false;
		if (_old_orderEntries.size() > 0)
		{
			restore = true;
			setFieldValue(orderEntriesField, c, new ArrayList());
		}
		c.setProjection(Projections.rowCount());
		int rowCount = ((Long)c.uniqueResult()).intValue();
		page.setTotalCount(rowCount);
		if (rowCount == 0)
			return Collections.EMPTY_LIST;
		if (restore)
			setFieldValue(orderEntriesField, c, _old_orderEntries);
		return c.setFirstResult(page.getFirstResult()).setMaxResults(page.getPageSize()).setFetchSize(page.getPageSize()).list();
	}

	@SuppressWarnings("unchecked")
	private static Field getField(Class clazz, String fieldName)
	{
		try{
			return clazz.getDeclaredField(fieldName);
		}catch(Exception e){
			logger.warn("Class.getDeclaredField(String) failed.", e);
			throw new RuntimeException(e);
		}
	}

	private static Object getFieldValue(Field field, Object obj)
	{
		try{
			field.setAccessible(true);
			return field.get(obj);
		}catch(Exception e){
			logger.warn("Field.get(Object) failed.", e);
			throw new RuntimeException(e);
		}
		
	}

	private static void setFieldValue(Field field, Object target, Object value)
	{
		field.setAccessible(true);
		try
		{
			field.set(target, value);
		}
		catch (Exception e)
		{
			logger.warn("Field.set(Object, Object) failed.", e);
			throw new RuntimeException(e);
		}
	}
}
