package edu.ecompus.core.dao.impl;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.springframework.orm.hibernate3.HibernateCallback;

import edu.ecompus.core.entity.Page;


/**
 * DAO基层接口实现类
 * 
 * 
 * @param <T>
 * Project:               E-COMPUS CORE
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-3-28 上午9:38:55
 */
public class ML2TemplateGenericDao<T> extends ML2GenericHibernateDao {
	@SuppressWarnings("unchecked")
	protected final Class clazz;
	
	@SuppressWarnings("unchecked")
	public ML2TemplateGenericDao(Class clazz)
	{
		this.clazz = clazz;
	}
	
	/**
	 * 查询clazz实体
	 * @param id
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public T query(Serializable id)
	{
		return (T) this.hibernateTemplate.get(clazz, id);
	}
	
	/**
	 * 创建clazz
	 * @param t
	 */
	public void create(T t)
	{
		this.hibernateTemplate.save(t);
	}

	/**
	 * 删除clazz
	 * @param t
	 */
	public void delete(T t)
	{
		this.hibernateTemplate.delete(t);
	}

	/**
	 * 更新clazz
	 * @param t
	 */
	public void update(T t)
	{
		this.hibernateTemplate.update(t);
	}
	
	/**
	 * 执行HSQL语句
	 * @param updateHql hsql语句
	 * @param values	参数
	 * @return
	 */
	protected int executeUpdate(final String updateHql, final Object values[])
	{
		HibernateCallback updateCallback = new HibernateCallback() {
			public Object doInHibernate(Session session)
				throws HibernateException, SQLException
			{
				Query query = session.createQuery(updateHql);
				if (values != null)
				{
					for (int i = 0; i < values.length; i++)
						query.setParameter(i, values[i]);

				}
				return new Integer(query.executeUpdate());
			}
			
		};
		return ((Integer)this.hibernateTemplate.execute(updateCallback)).intValue();
	}

	/**
	 * 查询实体列表
	 * @param selectCount	查询个数
	 * @param select		hsql查询语句
	 * @param values		参数
	 * @param page			分页
	 * @return
	 */
	@SuppressWarnings("unchecked")
	protected List queryForList(String selectCount, String select, Object values[], Page page)
	{
		Long count = (Long)queryForObject(selectCount, values);
		if (null != count)
			page.setTotalCount(count.intValue());
		if (page.isEmpty())
			return Collections.EMPTY_LIST;
		else
			return queryForList(select, values, page);
	}

	/**
	 * 查询实体列表
	 * @param count		查询个数
	 * @param select	hsql语句
	 * @param values	hsql参数
	 * @param page		分页
	 * @return
	 */
	@SuppressWarnings("unchecked")
	protected List queryForList(int count, String select, Object values[], Page page)
	{
		page.setTotalCount(count);
		if (page.isEmpty())
			return Collections.EMPTY_LIST;
		else
			return queryForList(select, values, page);
	}

	/**
	 * 模糊查询实体列表
	 * @param selectCount	查询个数
	 * @param select		hsql语句
	 * @param values		hsql参数
	 * @param page			分页
	 * @return
	 */
	@SuppressWarnings("unchecked")
	protected List queryForListAndLike(String selectCount, String select, Object values[], Page page)
	{
		Long count = (Long)queryForObjectAndLike(selectCount, values);
		page.setTotalCount(count.intValue());
		if (page.isEmpty())
			return Collections.EMPTY_LIST;
		else
			return queryForListAndLike(select, values, page);
	}
	
	/**
	 * 模糊查询实体
	 * @param select
	 * @param values
	 * @return
	 */
	protected Object queryForObjectAndLike(final String select, final Object values[])
	{
		HibernateCallback selectCallback = new HibernateCallback() {
			public Object doInHibernate(Session session)
			{
				Query query = session.createQuery(select);
				if (values != null)
				{
					for (int i = 0; i < values.length; i++)
						query.setString(0, (new StringBuilder()).append("%").append(values[i]).append("%").toString());

				}
				return query.uniqueResult();
			}
		};
		return this.hibernateTemplate.execute(selectCallback);
	}
	
	/**
	 * 模糊查询实体列表
	 * @param select	hsql语句 
	 * @param values	hsql参数
	 * @param page		分页
	 * @return
	 */
	@SuppressWarnings("unchecked")
	protected List queryForListAndLike(final String select, final Object values[], final Page page)
	{
		HibernateCallback selectCallback = new HibernateCallback() {
			public Object doInHibernate(Session session)
			{
				Query query = session.createQuery(select);
				if (values != null)
				{
					for (int i = 0; i < values.length; i++)
						query.setString(0, (new StringBuilder()).append("%").append(values[i]).append("%").toString());

				}
				return query.setFirstResult(page.getFirstResult()).setMaxResults(page.getPageSize()).list();
			}
		};
		return this.hibernateTemplate.executeFind(selectCallback);
	}

	/**
	 * 查询实体列表
	 * @param select	hsql语句
	 * @param values	hsql参数
	 * @param page		分页
	 * @return
	 */
	@SuppressWarnings("unchecked")
	protected List queryForList(final String select, final Object values[], final Page page)
	{
		HibernateCallback selectCallback = new HibernateCallback() {
			public Object doInHibernate(Session session)
			{
				Query query = session.createQuery(select);
				if (values != null)
				{
					for (int i = 0; i < values.length; i++)
						query.setParameter(i, values[i]);

				}
				return query.setFirstResult(page.getFirstResult()).setMaxResults(page.getPageSize()).list();
			}
		};
		return this.hibernateTemplate.executeFind(selectCallback);
	}
	
	/**
	 * 查询实体
	 * @param select 	hsql语句
	 * @param values	hsql参数
	 * @return
	 */
	protected Object queryForObject(final String select, final Object values[])
	{
		HibernateCallback selectCallback = new HibernateCallback() {
			public Object doInHibernate(Session session)
			{
				Query query = session.createQuery(select);
				if (values != null)
				{
					for (int i = 0; i < values.length; i++)
						query.setParameter(i, values[i]);

				}
				return query.uniqueResult();
			}
		};
		return this.hibernateTemplate.execute(selectCallback);
	}

	protected Object queryForObject(final DetachedCriteria dc)
	{
		HibernateCallback callback = new HibernateCallback() {
			public Object doInHibernate(Session session)
			{
				return dc.getExecutableCriteria(session).uniqueResult();
			}
		};
		return this.hibernateTemplate.execute(callback);
	}

	@SuppressWarnings("unchecked")
	protected List queryForList(final DetachedCriteria dc, final Page page)
	{
		HibernateCallback callback = new HibernateCallback() {
			public Object doInHibernate(Session session)
			{
				Criteria c = dc.getExecutableCriteria(session);
				if (page == null)
					return c.list();
				else
					return PaginationCriteria.query(c, page);
			}
		};
		return this.hibernateTemplate.executeFind(callback);
	}

	protected Object uniqueResult(final DetachedCriteria dc)
	{
		HibernateCallback callback = new HibernateCallback() {
			public Object doInHibernate(Session session)
			{
				return dc.getExecutableCriteria(session).uniqueResult();
			}
		};
		return this.hibernateTemplate.execute(callback);
	}
	
	/**
	 * 得到全部数据
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public List findAll() {
		HibernateCallback callback = new HibernateCallback() {
			public Object doInHibernate(Session session)
			{
				StringBuffer queryString = new StringBuffer(" FROM ").append(clazz.getSimpleName());
				queryString.append(" where id>0 ");
				Query query = session.createQuery(queryString.toString());
								
				return query.list();
			}
		};
		
		return this.hibernateTemplate.executeFind(callback);
	}
	
}
