package edu.ecompus.core.dao;

import java.io.Serializable;

/**
 * DAO 基层接口类
 * 
 * 
 * @param <T>
 * Project:               E-COMPUS CORE
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-3-28 上午9:21:58
 */
public abstract interface ML2GenericDao<T> {
	/**
	 * 查询对象
	 * @param id	查询编号
	 * @return
	 */
	public abstract T query(Serializable id);
	
	/**
	 * 创建对象
	 * @param obj
	 */
	public abstract void create(T obj);

	/**
	 * 删除对象
	 * @param obj
	 */
	public abstract void delete(T obj);

	/**
	 * 更新对象
	 * @param obj
	 */
	public abstract void update(T obj);
}
