package edu.ecompus.core.common.security;

import java.util.List;

import edu.ecompus.core.common.exception.ML2ServiceException;


/**
 * 安全验证码 接口类
 * @author Janny
 *
 */
public interface ML2CaptchaService {
	/**
	 * 生成验证码
	 * @return
	 * @throws ML2ServiceException
	 */
	public abstract String generateCaptchaKey() throws ML2ServiceException;
	
	/**
	 * 根据key生成验证码
	 * @param key
	 * @return
	 * @throws ML2ServiceException
	 */
	public abstract byte[] generateCaptchaImage(String key) throws ML2ServiceException;
	
	/**
	 * 验证key是否正确
	 * @param key
	 * @param userkey
	 * @return
	 * @throws ML2ServiceException
	 */
	public abstract boolean validateCaptcha(String key, String userkey) throws ML2ServiceException;
	
	@SuppressWarnings("unchecked")
	public abstract List getPreDefinedTexts();
	
	@SuppressWarnings("unchecked")
	public abstract void setPreDefinedTexts(List list);
}
