package edu.ecompus.core.common.exception;

/**
 * MINILIVE2 服务层异常定义
 * @author Janny
 *
 */
public class ML2ServiceException extends RuntimeException {
	private static final long serialVersionUID = 1631332445280234484L;
	
	private String code;
	private Object args[];
	
	public ML2ServiceException()
	{
	}

	public ML2ServiceException(String message, Throwable cause)
	{
		super(message, cause);
	}

	public ML2ServiceException(String message)
	{
		super(message);
	}

	public ML2ServiceException(Throwable cause)
	{
		super(cause);
	}

	public ML2ServiceException(String code, String message)
	{
		super(message);
		this.code = code;
		args = new Object[0];
	}
	
	
	public String getCode()
	{
		return code;
	}

	public Object[] getArgs()
	{
		return args;
	}
	
	
}
