/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.listener;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ML2LogbackConfigListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(ML2LogbackConfigListener.class);
    private static final String CONFIG_LOCATION = "logbackConfigLocation";

    public void contextInitialized(ServletContextEvent event) {
        String logbackConfigLocation = event.getServletContext().getInitParameter(CONFIG_LOCATION);
        String fn = event.getServletContext().getRealPath(logbackConfigLocation);
        try {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.reset();
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            joranConfigurator.setContext((Context)loggerContext);
            joranConfigurator.doConfigure(fn);
            logger.debug("loaded slf4j configure file from {}", (Object)fn);
        }
        catch (JoranException e) {
            logger.error("can loading slf4j configure file from " + fn, (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }
}

