/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.core.filter;

import edu.ecompus.core.jmx.ML2Sampler;
import edu.ecompus.core.util.HttpUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(PerformanceFilter.class);
    public static final ThreadLocal businessPerf = new ThreadLocal();
    public static final ThreadLocal daoPerf = new ThreadLocal();
    private static final String START_TIME = "ST_PERF_FILTER";
    private ML2Sampler httpSampler;
    private ML2Sampler businessSampler;
    private ML2Sampler daoSampler;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String url = HttpUtil.getURL((HttpServletRequest)request);
        if (url.endsWith("/checkState")) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(START_TIME, (Object)new Long(System.currentTimeMillis()));
        try {
            businessPerf.set(new Long(0L));
            daoPerf.set(new Long(0L));
            chain.doFilter(request, response);
            long httpTime = System.currentTimeMillis() - (Long)request.getAttribute(START_TIME);
            long businessTime = (Long)businessPerf.get();
            long daoTime = (Long)daoPerf.get();
            long businessPercent = httpTime != 0L ? businessTime * 100L / httpTime : 0L;
            long daoPercent = httpTime != 0L ? daoTime * 100L / httpTime : 0L;
            this.httpSampler.sample(httpTime);
            this.businessSampler.sample(businessTime);
            this.daoSampler.sample(daoTime);
            logger.info(url + " execution: " + httpTime + "ms.");
            logger.info("Business execution: " + businessTime + "ms, " + businessPercent + "%");
            logger.info("Dao execution: " + daoTime + "ms, " + daoPercent + "%");
            businessPerf.remove();
            daoPerf.remove();
        }
        catch (Exception exception) {
            long httpTime = System.currentTimeMillis() - (Long)request.getAttribute(START_TIME);
            long businessTime = (Long)businessPerf.get();
            long daoTime = (Long)daoPerf.get();
            long businessPercent = httpTime != 0L ? businessTime * 100L / httpTime : 0L;
            long daoPercent = httpTime != 0L ? daoTime * 100L / httpTime : 0L;
            this.httpSampler.sample(httpTime);
            this.businessSampler.sample(businessTime);
            this.daoSampler.sample(daoTime);
            logger.info(url + " execution: " + httpTime + "ms.");
            logger.info("Business execution: " + businessTime + "ms, " + businessPercent + "%");
            logger.info("Dao execution: " + daoTime + "ms, " + daoPercent + "%");
            businessPerf.remove();
            daoPerf.remove();
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void setHttpSampler(ML2Sampler httpSampler) {
        this.httpSampler = httpSampler;
    }

    public void setBusinessSampler(ML2Sampler businessSampler) {
        this.businessSampler = businessSampler;
    }

    public void setDaoSampler(ML2Sampler daoSampler) {
        this.daoSampler = daoSampler;
    }
}

